/* Another solution to the jury problem */
/* (uses slow algorithm) */

#include <stdio.h>

#define N_MAX 200
#define M_MAX 20

static short pval[N_MAX+1], dval[N_MAX+1];  /* juror value */
static short n, m;
static int case_no;

void solve ()
{
  int best_p, best_d, best_diff, best_sum, nsols;
  int cands, cand, psum, dsum, diff, i;
  short first[M_MAX], sol[M_MAX];

  printf("Jury #%d\n", ++case_no);
  best_p = best_d = 0;
  best_diff = 20*m + 1; /* best achieved difference */
  best_sum = -1; /* best achieved sum */
  cands = 0; /* size of current selection */
  cand = 0; /* current candidate */
  psum = dsum = 0; /* values of current selection */
  do {
    if (cands < m) { /* selection not complete */
      first[cands++] = cand; /* store current candidate and proceed */
    } else { /* cands == m */
      diff = abs(psum - dsum);
      if (diff < best_diff || (diff == best_diff && psum + dsum > best_sum)) {
	best_p = psum; best_d = dsum;
	best_diff = diff; best_sum = psum + dsum;
	for (i = 1; i < m; i++)
	  sol[i] = first[i];
	sol[m] = cand;
	nsols = 1;
      } else if (diff == best_diff && psum + dsum == best_sum)
	nsols++;
      
      psum -= pval[cand];
      dsum -= dval[cand];
    }
    while (cands > 0 && cand == n) { /* backtrack */
      cand = first[--cands];
      psum -= pval[cand];
      dsum -= dval[cand];
    }
    cand++;
    if (cand <= n) {
      psum += pval[cand];
      dsum += dval[cand];
    }
  } while (cands > 0);
  
  if (nsols > 1)
    fprintf(stderr, "*** Jury #%d has non-unique solution ***\n", case_no);
  
  printf("Best jury has value %d for prosecution ", best_p);
  printf("and value %d for defense:\n", best_d);
  for (i = 1; i <= m; i++)
    printf(" %d", sol[i]);
  printf("\n\n");
}

int read (FILE *file)
{
  int i;

  fscanf(file, "%d%d\n", &n, &m);
  for (i = 1; i <= n; i++)
    fscanf(file, "%d%d\n", &pval[i], &dval[i]);
  return n > 0;
}

void main ()
{
  FILE *in;

  if (in = fopen("jury.in", "r")) {
    while (read(in))
      solve();
    fclose(in);
  }
}
