/* Solution checker: JURY */
/* checks solution read from stdin */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define POOL_MAX 500
#define VALUE_MAX 21
#define JURY_MAX 30

FILE *inp;
int prosecution[POOL_MAX],defense[POOL_MAX];
int m,n;
int caseno = 1;

int last[JURY_MAX][2*VALUE_MAX*JURY_MAX+1];
int sum[JURY_MAX][2*VALUE_MAX*JURY_MAX+1];

/* read one line from stdin */

int line = 0,
  err = 0;

void readline(char *buf, int removeblanks)
{
  line++;
  
  if(feof(stdin))
   { 
      printf("line %2d\n *** WRONG ANSWER: Input too short!\n",line); 
      exit(1);
    }
  if(!fgets(buf,1000,stdin)) strcpy(buf,"***EOF***");

  /* remove trailing blanks */
  if(removeblanks)
    while(*buf && buf[strlen(buf)-1] < 33) buf[strlen(buf)-1] = 0;
  else
    while(*buf && buf[strlen(buf)-1] < 32) buf[strlen(buf)-1] = 0;
}

int compare(const void *a, const void *b)
{
  return *((const int *) a) - *((const int *) b);
}

/* solve problem by dynamic programming:
   * for each number of jurors 1,...,m, and for each distance D(J)-P(J), 
     the maximum possible sum D(J)+P(J) (at the given distance) is computed by
     dynamic programming
   * at the end we just have to read off the minimal possible distance and the
     corresponding maximum sum
*/

void solve_case()
{
  int i,j,k,l,l2;
  int sol[JURY_MAX];
  char tmpbuf[1000],inbuf[1000],outbuf[1000];
  int inlen,cse,a,b;
  char *c;

  /* initialize array */
  for(i=0;i<m;i++)
    for(j=0;j<2*VALUE_MAX*m+1;j++) 
      last[i][j] = sum[i][j] = -1;

  /* solve problem for 1 juror */
  for(i=0;i<n;i++)
    if(prosecution[i] + defense[i] > 
       sum[0][VALUE_MAX*m+prosecution[i]-defense[i]])
      {
	last[0][VALUE_MAX*m+prosecution[i]-defense[i]] = i;
	sum[0][VALUE_MAX*m+prosecution[i]-defense[i]] = 
	  prosecution[i] + defense[i];
      }

  /* build upon that to solve problem for 2,3,...m jurors */
  for(j=0;j<m-1;j++)
    for(k=0;k<2*VALUE_MAX*m;k++)
      if(last[j][k] >= 0)
	for(i=0;i<n;i++)
	  if(sum[j+1][k+prosecution[i]-defense[i]] <
	     sum[j][k] + prosecution[i] + defense[i])
	    {
	      /* make sure that every person is used only once in a jury */
	      for(l=j,l2=k;l>=0;l--)
		{
		  if(last[l][l2] == i) break;
		  l2 -= prosecution[last[l][l2]]-defense[last[l][l2]];
		}
	      if(l < 0)
		{
		  /* add person to jury */
		  last[j+1][k+prosecution[i]-defense[i]] = i;
		  sum[j+1][k+prosecution[i]-defense[i]] = 
		    sum[j][k] + prosecution[i] + defense[i];
		}
	    }
	    
  /* determine minimum possible |D(J)-P(J)| */
  for(i=0;i<=VALUE_MAX*m;i++)
    if(sum[m-1][VALUE_MAX*m+i] >= 0 || sum[m-1][VALUE_MAX*m-i] >= 0)
      {
	if(sum[m-1][VALUE_MAX*m+i] > sum[m-1][VALUE_MAX*m-i])
	  i = VALUE_MAX*m+i;
	else
	  i = VALUE_MAX*m-i;
	break;
      }
  
  /* output solution in the desired format */

  readline(inbuf,0);
  sprintf(outbuf,"Jury #%d",caseno++);
  if(strcmp(inbuf,outbuf))
    {
      printf("line %2d > %s\n        < %s\n",line,inbuf,outbuf);
      err = 1;
    }

  readline(inbuf,0);
  sprintf(outbuf,
	  "Best jury has value %d for prosecution and value %d for defence:",
	  (sum[m-1][i]+(i-VALUE_MAX*m))/2,(sum[m-1][i]-(i-VALUE_MAX*m))/2);
  cse = 0;
  if(strcmp(inbuf,outbuf))
    {
      sprintf(outbuf,
	      "Best jury has value %d for prosecution and value %d for defence:",
	      (sum[m-1][i]-(i-VALUE_MAX*m))/2,(sum[m-1][i]+(i-VALUE_MAX*m))/2);
      cse = 1;
      if(strcmp(inbuf,outbuf))
	{
	  printf("line %2d > %s\n        < %s\n",line,inbuf,outbuf);
	  cse = 2;
	  err = 1;
	}
    }

  readline(inbuf,1); strcpy(tmpbuf,inbuf);
  for(c=tmpbuf;*c&&*c<33;c++);
  for(k=0,c=strtok(c," ");k<m;k++,c=strtok(0," "))
    {
      if(!c || !*c)
	{	
	  printf("line %2d > %s\n *** WRONG ANSWER: Too few judges!\n",
		 line,inbuf);
	  exit(1);
	}
      for(j=0;j<strlen(c);j++)
	if(!isdigit(c[j]))
	  {
	    printf("line %2d > %s\n *** WRONG ANSWER: Not a number (%s)!\n",
		   line,inbuf,c);
	    exit(1);
	  }
      sol[k] = atoi(c);
      if(sol[k] < 1 || sol[k] > n)
	{
	  printf("line %2d > %s\n *** WRONG ANSWER: Invalid number (%d)!\n",
		 line,inbuf,sol[k]);
	  exit(1);
	}
      if(k && (sol[k] <= sol[k-1]))
	{
	  printf("line %2d > %s\n *** PRESENTATION ERROR: Numbers not ordered!\n",
		 line,inbuf);
	  err = 1;
	}
    }
  if(c && *c)
    {
      printf("line %2d > %s\n *** WRONG ANSWER: Too many judges!\n",
	     line,inbuf);
      exit(1);
    }
  qsort(sol,m,sizeof(int),compare);
  for(j=1;j<m;j++)
    if(sol[j-1] == sol[j])
      {
	printf("line %2d > %s\n *** WRONG ANSWER: Number %d occurs twice!\n",
	       line,inbuf,sol[j]);
	exit(1);
      }

  for(a=b=j=0;j<m;j++)
    {
      a += prosecution[sol[j]-1];
      b += defense[sol[j]-1];
    }

  if(a == (sum[m-1][i]+(i-VALUE_MAX*m))/2 &&
     b == (sum[m-1][i]-(i-VALUE_MAX*m))/2)
    if(cse == 0 || cse == 2) goto ok;
  if(b == (sum[m-1][i]+(i-VALUE_MAX*m))/2 &&
     a == (sum[m-1][i]-(i-VALUE_MAX*m))/2)
    if(cse == 1 || cse == 2) goto ok;

  printf("line %2d > %s\n *** WRONG ANSWER: Sums (%d %d) are incorrect!\n",
	 line,inbuf,a,b);
  exit(1);

ok:
  if(cse == 2)
    printf("line %2d > %s\n *** NOTE: Sums are %d / %d - compare to line %d\n",line,inbuf,a,b,line-1);
  readline(inbuf,0);
  if(*inbuf)
    {
      printf("line %2d > %s\n        < \n",line,inbuf);
      err = 1;
    }
}

/* read in one input case */

void skip_line() { while(getc(inp) >= ' '); }


int read_case()
{
  int i;

  fscanf(inp,"%d %d",&n,&m); 
  if(n == 0) return 0;
  skip_line();
  if(n < m)
    fprintf(stderr,"ERROR: n < m\n");
  for(i=0;i<n;i++)
    {
      fscanf(inp,"%d %d",prosecution+i,defense+i);
      skip_line();
    }
  return 1;
}

int main()
{
  char buf[1000];

  inp = fopen("jury.in","r");
  while(read_case()) solve_case();
  fclose(inp);
  while(!feof(stdin))
    {
      if(!fgets(buf,1000,stdin)) break;
      while(*buf && buf[strlen(buf)-1] < 32) buf[strlen(buf)-1] = 0;
      if(*buf)
	{
	  printf("line %2d > %s\n *** PRESENTATION ERROR: File too long\n",++line,buf);
	  err = 1;
	}
    }
  if(!err) printf(" *** CORRECT!\n");
  return err;
}


