/* $Id: pendulum2.c,v 1.3 1996/11/08 09:07:24 strebel Exp $ */

#include <stdio.h>
#include <math.h>

#ifndef DEBUG
#define DEBUG 0
#endif
#ifndef OUTPUT
#define OUTPUT 1
#endif

#define MAX_HOOKS 1000

typedef struct { double x, y; } Hook;

Hook h[MAX_HOOKS];
int nofh;
double len;
FILE *f;

const double PI = M_PI;
const double EPS = 1e-8;

#define SQR(x) ((x)*(x))

double dist (Hook a, Hook b)
{
  return sqrt(SQR(a.x - b.x) + SQR(a.y - b.y));
}

int less (double alpha, double beta)
{
  return (alpha + EPS <= beta);
}

double angle (Hook a, Hook b, double angle_min)
{
  double phi;

  phi = atan2 (b.y - a.y, b.x - a.x);
  while (less(phi,angle_min)) phi += 2*PI;
  return (phi);
}

void solve (void)
{
  Hook hnow = {0,0};
  double lnow = len, path = 0;
  double phinow = PI;
  double d, a;
  int i;

  while (1) {
    int nxt = -1;
    double phimin = phinow + 2*PI;
    int noturn = (hnow.y + lnow > 0);
    Hook hturn;

    if (noturn) {
      hturn.x = hnow.x + sqrt(SQR(lnow) - SQR(hnow.y));
      hturn.y = 0;
      phimin = angle(hnow, hturn, phinow);
    }  
    for (i = 0; i < nofh; i++) {
      if (((d = dist(hnow, h[i])) > 0) && (d < lnow)
	  && less (a = angle(hnow, h[i], phinow), phimin)) {
	nxt = i;
	phimin = a;
      }
    }
    if (nxt == -1) {
      if (noturn) {
	path += lnow*(phimin - phinow);
#if (OUTPUT == 1)
	printf ("Returns at (%.2f, %.2f), length = %.2f\n\n",
		hturn.x, hturn.y, path);
#endif
	path *= 2;
      } else {
	path = 2*PI*lnow;
#if (OUTPUT == 1)
	printf ("Circles around (%.2f, %.2f), length = %.2f\n\n",
		hnow.x, hnow.y, path);
#endif
      }
#if (OUTPUT == 2)
      printf ("Length of periodic orbit = %.2f\n\n", path);
#endif
      break;
    }
    path += lnow*(phimin - phinow);
    lnow -= dist(hnow,h[nxt]);
    hnow  = h[nxt];
    phinow= phimin;
  }
}

void skip_line (void) 
{ 
  while(getc(f) >= ' '); 
}

int get (void)
{
  int i;

  fscanf (f, "%d %lf", &nofh, &len);
  if (len == 0) return (0);
  skip_line();
  for (i = 0; i < nofh; i++) {
    fscanf (f, "%lf %lf", &(h[i].x), &(h[i].y));
    skip_line();
  }
  return (1);
}

void main (void)
{
  int i = 0;

  f = fopen ("pendulum.in", "r");
  while (get()) {
    printf ("Pendulum #%d\n", ++i);
    solve ();
  }
  exit (0);
}



