/* Solution: STARS */

#include <stdio.h>
#include <math.h>

#define MAX_MAP_SIZE 1000
#define MAX_CONSTELLATION_SIZE 50
#define MAX_NAME_LENGTH 50
#define EPS 1e-5

typedef struct { int x,y,b; } star;

FILE *inp;

star map[MAX_MAP_SIZE];
star con[MAX_CONSTELLATION_SIZE];
star sol[MAX_CONSTELLATION_SIZE];
char conname[MAX_NAME_LENGTH+1];
int mapsize,consize,solbright,solnum;

int caseno = 1;

int compare(star *a, star *b)
{
  if(a->x != b->x) return a->x - b->x;
  else return a->y - b->y;
}

/* compute the number of occurrences */

int occur(star *ap, star *bp, int asize, int bsize)
{
  int p,q,c,d;
  int i,j,k,l,ix,iy;
  double a,b,x,y;
  int n;
  static star tmpsol[MAX_CONSTELLATION_SIZE];
  int tmpbright;

  if(asize > bsize) return 0;
  /* handle a single star seperately */
  if(asize == 1)
    {
      solbright = -1;
      for(i=0;i<bsize;i++)
	if(solbright < bp[i].b)
	  { sol[0] = bp[i]; solbright = bp[i].b; solnum = 1; }
	else if(solbright == bp[i].b) solnum++;
      return bsize;
    }
  /* now for the funky stuff */
  p = ap[1].x - ap[0].x;
  q = ap[1].y - ap[0].y;
  n = 0;
  /* for all pairs (i,j) of stars from the map: scale and rotate the
     constellation such that the first two stars of the constellation land
     on i and j respectively
     then compute the positions of the remaining stars of the constellation
     and check whether there is a corresponding star in the map at that
     position. If this test passes for all stars of the constellation,
     we have found one occurrence.
     */
  for(i=0;i<bsize;i++)
    for(j=0;j<bsize;j++)
      if(i != j)
	{
	  tmpbright = bp[i].b + bp[j].b;
	  tmpsol[0] = bp[i];
	  tmpsol[1] = bp[j];
	  for(k=2;k<asize;k++)
	    {
	      /* computing the transformed position of the stars in the
		 constellation is done with a little linear algebra. The
		 transformation is determined by the image of the first two
		 stars of the constellation */
	      c = ap[k].x - ap[0].x;
	      d = ap[k].y - ap[0].y;
	      a = (double)(c*p+d*q)/(double)(p*p+q*q);
	      b = (double)(d*p-c*q)/(double)(p*p+q*q);
	      x = a*(bp[j].x-bp[i].x)-b*(bp[j].y-bp[i].y)+bp[i].x;
	      y = a*(bp[j].y-bp[i].y)+b*(bp[j].x-bp[i].x)+bp[i].y;
	      /* check if both coordinates (x,y) are integers */
	      ix = rint(x);
	      iy = rint(y);
	      if(fabs(x-(double)ix) > EPS || fabs(y-(double)iy) > EPS)
		goto skipthis;
	      /* check if there is a star in the map at position (x,y) */
	      for(l=0;l<bsize;l++)
		if(bp[l].x == ix && bp[l].y == iy)
		  break;
	      if(l == bsize) goto skipthis;
	      /* if all passed, store the position */
	      tmpsol[k] = bp[l]; tmpbright += bp[l].b;
	    }
	  /* do we have the brightest occurrence so far? */
	  if(tmpbright > solbright) 
	    { 
	      /* store occurrence for later output */
	      solbright = tmpbright; solnum = 1;
	      for(k=0;k<asize;k++) sol[k] = tmpsol[k];
	    }
	  else if(tmpbright == solbright) solnum++; /* not unique */
	  n++;
	skipthis: ;
	}
  return n;
}

void skip_line() { while(getc(inp) >= ' '); }

int solve_case()
{
  int i,j,k,connum,autsize,occ;

  /* read in map */
  fscanf(inp,"%d",&mapsize);
  if(mapsize == 0) return 0;
  skip_line();

  printf("Map #%d\n",caseno++);

  for(i=0;i<mapsize;i++)
    {
      fscanf(inp,"%d %d %d",&map[i].x,&map[i].y,&map[i].b);
      for(j=0;j<i;j++) 
	if(map[i].x == map[j].x && map[i].y == map[j].y)
	  printf("*** INPUT Error: Point occurs more than once in map!\n");
      skip_line();
    }
  fscanf(inp,"%d",&connum); skip_line();
  for(i=0;i<connum;i++)
    {
      /* read in constellation */
      fscanf(inp,"%d %s",&consize,conname);
      skip_line();
      for(j=0;j<consize;j++)
	{
	  fscanf(inp,"%d %d",&con[j].x,&con[j].y);
	  for(k=0;k<j;k++) 
	    if(con[k].x == con[j].x && con[k].y == con[j].y)
	      printf("*** INPUT Error: Point occurs more than once in constellation!\n");
	  skip_line();
	}

      /* compute size of automorphism group of constellation, an occurrence
	 in the starmap will be counted 'autsize' times. Therefore, we have
	 to divide 'occ' by 'autsize' below. */
      autsize = occur(con,con,consize,consize);
      /* compute occurrences in map */
      solbright = -1; solnum = 0;
      occ = occur(con,map,consize,mapsize);
      
      /* output solution */
      printf("\n");
      printf("%s occurs %d time(s) in the map.\n",conname,occ/autsize);
      if(occ != 0)
	{
	  if(solnum != autsize)
	    printf("*** INPUT Error: Multiple brightest occurences (%d)!\n",
		   solnum/autsize);

	  /* sort stars in solution */
	  qsort(sol,consize,sizeof(star),compare);

	  printf("Brightest occurrence:");
	  for(j=0;j<consize;j++)
	    printf(" (%d,%d)",sol[j].x,sol[j].y);
	  printf("\n");
	}
    }
  printf("-----\n");
  return 1;
}

int main()
{
  inp = fopen("stars.in","r");
  while(solve_case());
  fclose(inp);
  return 0;
}

