/* SWERC'97 - MBone         */
/* 11/13/97 - Matthias Ruhl */

#include <stdio.h>
#include <assert.h>

FILE *inp;
int m;
char island[10][21];
struct { int num,island; } host[50];
struct { int num,member[50],membernum; } group[20];
typedef struct { int host,data,ttl; } packetT;
packetT packet[50*1000];
int hostnum,packetnum,dist[10][10];

void read_network()
{
  int h,i,j,k,l,ttl;
  char name[21],ch;

  /* Initialize variables */
  hostnum = packetnum = 0;
  for(i=0;i<m;i++)
    {
      island[i][0] = 0;
      for(j=0;j<m;j++) dist[i][j] = -1;
      dist[i][i] = 0;
    }
  for(i=0;i<20;i++) { group[i].membernum = 0; }

  for(i=0;i<m;i++)
    {
      fscanf(inp,"%s %d",name,&l);
      for(j=0;j<m;j++)
	if(island[j][0] == 0 || !strcmp(name,island[j])) break;
      if(island[j][0] == 0) strcpy(island[j],name);
      for(k=0;k<l;k++)
	{
	  fscanf(inp," %c",&ch);
	  if(ch == 'H')
	    {
	      fscanf(inp,"%d",&h);
	      host[hostnum].num = h;
	      host[hostnum].island = j;
	      hostnum++;
	    }
	  else /* ch == 'T' */
	    {
	      fscanf(inp,"%d %s",&ttl,name);
	      for(h=0;h<m;h++)
		if(island[h][0] == 0 || !strcmp(name,island[h]))
		  break;
	      if(island[h][0] == 0) strcpy(island[h],name);
	      dist[j][h] = ttl;
	    }
	}
    }

  ch = 1;
  while(ch)
    {
      ch = 0;
      for(i=0;i<m;i++)
	for(j=0;j<m;j++)
	  for(k=0;k<m;k++)
	    if(dist[i][k] >= 0 && dist[k][j] >= 0 &&
	       (dist[i][j] < 0 || dist[i][j] > dist[i][k] + dist[k][j]))
	      {
		dist[i][j] = dist[i][k] + dist[k][j];
		ch = 1;
	      }
    }
}

void simulate_network()
{
  int i,j,k,n,h,g,d,ttl,is;
  char ch;

  fscanf(inp,"%d",&n);
  for(i=0;i<n;i++)
    {
      fscanf(inp," %c %d %d",&ch,&h,&g);
      for(j=0;j<hostnum;j++) if(host[j].num == h) break;
      h = j;
      assert(h < hostnum);
      switch(ch)
	{
	case 'J':
	  for(j=0;j<20;j++) if(group[j].num == g) break;
	  if(j == 20)
	    {
	      for(j=0;j<20;j++) if(group[j].membernum == 0) break;
	      assert(j < 20);
	      group[j].num = g;
	    }
	  for(k=0;k<group[j].membernum;k++)
	    if(group[j].member[k] == h) break;
	  if(k == group[j].membernum) /* new member */
	    group[j].member[group[j].membernum++] = h;
	  break;
	case 'L':
	  for(j=0;j<20;j++) if(group[j].num == g) break;
	  if(j < 20) /* group really exists */
	    {
	      for(k=0;k<group[j].membernum;k++)
		if(group[j].member[k] == h) break;
	      if(k < group[j].membernum) /* really a member */
		{
		  if(k != --group[j].membernum)
		    group[j].member[k] = group[j].member[group[j].membernum];
		}
	    }
	  break;
	case 'S':
	  fscanf(inp,"%d %d",&d,&ttl);
	  is = host[h].island;
	  for(j=0;j<20;j++) if(group[j].num == g) break;
	  if(j < 20) /* group exists */
	    {
	      for(k=0;k<group[j].membernum;k++)
		if(dist[is][host[group[j].member[k]].island] != -1 &&
		   dist[is][host[group[j].member[k]].island] <= ttl)
		  {
		    packet[packetnum].host = host[group[j].member[k]].num;
		    packet[packetnum].data = d;
		    packet[packetnum].ttl = ttl - dist[is][host[group[j].member[k]].island];
		    packetnum++;
		  }
	    }
	  break;
	}
    }
}

int compare(packetT *p1, packetT *p2)
{
  if(p1->host != p2->host) return p1->host - p2->host;
  if(p1->data != p2->data) return p1->data - p2->data;
  return p1->ttl - p2->ttl;
}

void output()
{
  static int caseno = 1;
  int i;

  qsort(packet,packetnum,sizeof(packetT),compare);
  printf("Network #%d\n",caseno++);
  for(i=0;i<packetnum;i++)
    printf("%d %d %d\n",packet[i].host,packet[i].data,packet[i].ttl);
  printf("\n");
}

int main()
{
  inp = fopen("mbone.in","r");
  while(fscanf(inp,"%d",&m) && m != 0)
    {
      read_network();
      simulate_network();
      output();
    }
}
