/* SWERC'98 - Solitary Games */
/* 10/17/98 - Matthias Ruhl  */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

const double eps = 1e-15;
const double eps2 = 1e-10;

FILE *inp;
int n,case_no = 1;
double p[26][26],s[26],f[26];

void skip_whitespace()
{
  int c;

  while((c = getc(inp)) <= ' ');
  ungetc(c,inp);
}

void get_tree(double *p, double *s, double *f)
{
  double tp[26],ts,tf;
  int c,ch = 0,i;
  
  for(i=0;i<n;i++) p[i] = 0.0;
  *s = *f = 0.0;
  skip_whitespace();
  c = getc(inp);
  if(isdigit(c) || c == '-')
    {
      ungetc(c,inp);
      fscanf(inp,"%d",&i);
      *s = (double) i;
      *f = 1.0;
      return;
    }
  if(isalpha(c))
    {
      assert('a' <= c && c < 'a'+n);
      p[c-'a'] = 1.0;
      return;
    }
  assert(c == '(');
  while(1)
    {
      ch++;
      get_tree(tp,&ts,&tf);
      for(i=0;i<n;i++) p[i] += tp[i];
      *s += ts; *f += tf;
      skip_whitespace();
      c = getc(inp);
      if(c == ')') break;
      ungetc(c,inp);
    }
  for(i=0;i<n;i++) p[i] /= (double) ch;
  *s /= (double) ch;
  *f /= (double) ch;
}

void read_trees()
{
  int i;

  for(i=0;i<n;i++)
    {
      skip_whitespace();
      assert(getc(inp) == ('a'+i));
      skip_whitespace();
      assert(getc(inp) == '=');
      get_tree(p[i],s+i,f+i);
    }
}

void process_trees()
{
  int i,j,it;
  double f0[26],f1[26],s0[26],s1[26];

  for(i=0;i<n;i++)
    {
      s0[i] = s[i];
      f0[i] = f[i];
    }
  it = 1;
  while(it)
    {
      it = 0;
      for(i=0;i<n;i++)
	{
	  s1[i] = s[i];
	  f1[i] = f[i];
	  for(j=0;j<n;j++)
	    {
	      s1[i] += p[i][j]*s0[j];
	      f1[i] += p[i][j]*f0[j];
	    }
	  if(fabs(s0[i] - s1[i]) > eps) it = 1;
	  if(fabs(f0[i] - f1[i]) > eps) it = 1;
	}
      for(i=0;i<n;i++) { s0[i] = s1[i]; f0[i] = f1[i]; }
    }
  printf("Game %d\n",case_no++);
  for(i=0;i<n;i++)
    {
      printf("Expected score for %c ",'a'+i);
      if(fabs(f0[i]-1.0) < eps2)
	printf("= %.3f\n",s0[i]);
      else
	printf("undefined\n");
    }
  printf("\n");

}

int main()
{
  inp = fopen("games.in","r");
  while(fscanf(inp,"%d",&n), n != 0)
    {
      read_trees();
      process_trees();
    }
  fclose(inp);
  return 0;
}
