/* Problem H: Sorting Slides
 * Author:    Mark Dettinger
 *
 * Algorithm:
 * 1.) Construct the following graph: 1 source node, n nodes for the slides,
 *     n nodes for the numbers, 1 sink. Edges from the source to each slide,
 *     from the slides to the possible numbers and from each number to the sink.
 * 2.) While there exists a path from the source to the sink, flip the direction
 *     of the edges along this path. (This will work exactly n times.) 
 * 3.) You now have found one possible matching: From each number there is an edge
 *     to its slide. Now output all pairs (slide,number) with the following property:
 *     Starting from the slide, the graph should contain no cycle. (If there is
 *     a cycle, it means that there exists a matching where the slide has written
 *     an other number on it.)
 */

#include <stdio.h>
#include <assert.h>

#define WHITE 0
#define GRAY 1
#define BLACK 2

typedef struct { int left,right,top,bottom; } slide;
typedef struct { int x,y; } point;

FILE *input;
int heap=0;
int n;
slide s[32];
point p[32];
int a[64][64];
int color[64];
int source,sink;

int read_case()
{
  int i;
  fscanf(input,"%d",&n);
  if (n==0) return 0;
  for (i=0; i<n; i++)
    fscanf(input,"%d %d %d %d",&s[i].left,&s[i].right,&s[i].top,&s[i].bottom);
  for (i=0; i<n; i++)
    fscanf(input,"%d %d",&p[i].x,&p[i].y);
  return 1;
}

int is_inside (point p, slide s)
{
  return p.x>s.left && p.x<s.right && p.y>s.top && p.y<s.bottom;
}

int visit (int node, int dest, int pathlength)
{
  int i;
  if (node==dest && pathlength>0) return 1;
  if (color[node]!=WHITE) return 0;
  color[node] = GRAY;
  for (i=0; i<=sink; i++)
    if (a[node][i])
      if (visit(i,dest,pathlength+1))
	{
	  a[i][node] = 1;
	  a[node][i] = 0;
	  return 1;
	}
  color[node] = BLACK;
  return 0;
}

void print_graph()
{
  int i,j;
  for (i=0; i<=sink; i++)
    {
      printf("%d: ",i);
      for (j=0; j<=sink; j++)
	if (a[i][j]) printf("%d ",j);
      printf("\n");
    }
}

void solve_case()
{
  int i,j,num_edges,pairs;

  printf("Heap %d\n",++heap);

  /* construct bipartite graph where nodes 0..n-1 correspond to the numbers and
   * nodes n..2n-1 correspond to the slides */
  source = 2*n;
  sink = 2*n+1;
  /* 1. init empty graph */
  for (i=0; i<=sink; i++)
    for (j=0; j<=sink; j++)
      a[i][j] = 0;
  /* 2. add edges */
  for (i=0; i<n; i++)
    for (j=0; j<n; j++)
      a[j][n+i] = is_inside(p[i],s[j]);
  /* 3. add source and sink */
  for (i=0; i<n; i++)
    a[source][i] = a[n+i][sink] = 1;

  /* find maximum matching by augmenting path method */
  num_edges = 0;
  while (1)
    {
      for (i=0; i<=sink; i++)
	color[i] = WHITE;
      if (!visit(source,sink,0)) break;
      num_edges++;
    }
  assert(num_edges==n); /* a maximum matching always exists */

  /* output all pairs that occur in every matching */
  pairs = 0;
  for (i=0; i<n; i++)
    {
      for (j=0; j<=sink; j++)
	color[j] = WHITE;
      if (!visit(i,i,0))
	{
	  for (j=n; j<2*n; j++)
	    if (a[j][i]) break;
	  assert(j<2*n);
	  printf("(%c,%d) ",'A'+i,j-n+1);
	  pairs++;
	}
    }
  if (pairs==0) printf("none");
  printf("\n\n");
}

int main()
{
  input = fopen("slides.in","r");
  assert(input!=NULL);
  while (read_case()) solve_case();
  fclose(input);
  return 0;
}
