program Camelot;

const TW = 8;
      TW2 = 2*TW;
      NKMAX = 63;
      UNKNOWN = -1;
      INFILE  = 'CAMELOT.IN';
      OUTFILE = 'CAMELOT.OUT';

type  Board    = array[0..TW-1,0..TW-1] of integer;
      BigBoard = array[0..TW2-1,0..TW2-1] of integer;
      BigString= string[255];

var NK : integer;                        (* # knights *)
    IP : array[0..2*NKMAX-1] of integer; (* input *)
    MCM: array[0..NKMAX-1] of Board;     (* cost matrices for matings *)
    KingMat : Board;
    KMats   : array[0..TW-1,0..TW-1] of Board; (* all-pos knights costs *)
    KBoard: BigBoard;

function CL(c:char):integer; (* chess letter *)
begin
  CL := ord(c) - ord('A');
end;

function CD(c:char):integer; (* chess digit *)
begin
  CD := ord(c) - ord('1');
end;

procedure Erase(var t:Board);
var h,v:integer;
begin
  for h:=0 to TW-1 do
    for v:=0 to TW-1 do
      t[h,v] := UNKNOWN;
end;

procedure AddBoard(a,b: Board; var c:Board);
var v,h:integer;
begin
  for v:=0 to TW-1 do
    for h:=0 to TW-1  do
      c[h,v] := a[h,v]+b[h,v];
end;

procedure KnightCosts(h,v,s:integer; var t:Board);
begin
    if(h>=0) and (h<TW) and (v>=0) and (v<TW) then
    if (t[h,v]<0) or (s<t[h,v]) then
        begin
         t[h,v] := s;
         inc(s);
         KnightCosts(h+2,v+1,s,t);
         KnightCosts(h+2,v-1,s,t);
         KnightCosts(h-2,v+1,s,t);
         KnightCosts(h-2,v-1,s,t);
         KnightCosts(h+1,v+2,s,t);
         KnightCosts(h+1,v-2,s,t);
         KnightCosts(h-1,v+2,s,t);
         KnightCosts(h-1,v-2,s,t);
        end;
end;

procedure KingCosts(h,v,s:integer; var t:Board);
var j:integer;
begin
  if(h>=0) and (h<TW) and (v>=0) and (v<TW) then
   if (t[h,v]<0) or (s<t[h,v]) then
    begin
       t[h,v] := s;
       inc(s);
       KingCosts(h,v+1,s,t);
       KingCosts(h,v-1,s,t);
       for j:=-1 to 1 do
         begin
           KingCosts(h+1,v+j,s,t);
           KingCosts(h-1,v+j,s,t);
         end
    end
end;

(* PreCompute Knight cost matrices for all 64 board positions *)

procedure ComputeKnightMats;
var h,v:integer;
begin
  for v := 0 to TW-1 do
    for h := 0 to TW-1 do
      begin
        Erase(KMats[h,v]);
        KnightCosts(h,v,0,KMats[h,v]);
      end;
end;

(* The cost matrix for Knight at h,v *)

procedure GetKnightCostMat(h,v:integer; var k:Board);
begin
  k := KMats[h,v];
end;

(* Minimum value of Board and Position *)

function MinVal(k:Board):integer;
var v,h,S:integer;
begin
  S:=k[0,0];
  for v:=0 to TW-1 do
    for h:=0 to TW-1 do
      if(k[h,v]<S) then
        S:=k[h,v];
  MinVal := S;
end;

(* Compute the matings cost matrices for all NK knights *)
(*                                                      *)
(* MCM[i] = combined cost of king mating Knight i       *)

procedure MakePairs;
var i,ii,h,v: integer;
    tb,km,tu,kmt:Board;
begin
  for i:=0 to NK-1 do
    begin
      ii := i*2;
      GetKnightCostMat(IP[ii],IP[ii+1],km);
      AddBoard(km,KingMat,tb);
      for h:=0 to TW-1 do
        for v:=0 to TW-1 do
          begin
            GetKnightCostMat(h,v,kmt);
            AddBoard(tb,kmt,tu);
            MCM[i][h,v]:=MinVal(tu);
          end;
    end
end;

procedure Results(ofname:string;val:integer);
var i:integer;
    f:text;
begin
  assign(f,ofname);
  rewrite(f);
  writeln(f,val);
  close(f);
end;

(* Pick the Best *)

function Best:integer;
var allknights,rn,someknight: Board;
    i,newval,val,ii,h,v: integer;

begin

  (* first case, no gathering *)

  GetKnightCostMat(IP[0],IP[1],allknights);

  ii := 2;
  for i:=1 to NK-1 do
    begin
      GetKnightCostMat(IP[ii],IP[ii+1],someknight);
      AddBoard(allknights,someknight,allknights);
      inc(ii,2);
    end;

  (* rs = sum of all knight matrices *)

  AddBoard(allknights,KingMat,rn);

  val := MinVal(rn);    (* first guess, no matings *)

  (* now, the NK possible matings *)

  ii := 0;
  for i:=0 to NK-1 do  (* mate with knight i *)
    begin
      GetKnightCostMat(IP[ii],IP[ii+1],someknight);
      (* someknight = costs of Knight i *)

      for h:=0 to TW-1 do   (* rn = rs - kt + MCM[i] *)
        for v:=0 to TW-1 do
          rn[h,v] := allknights[h,v] - someknight[h,v] + MCM[i][h,v];

      newval := MinVal(rn);
      if(newval<val)then
        val := newval;
      inc(ii,2);
    end;
  writeln(val);
  Best :=val;
end;


procedure ReadPieces(fname:string);
var  f  : text { file} ;
     buf: bigstring;
     i  : integer;
begin
  assign(f,fname);
  reset(f);
  readln(f,buf);
  close(f);
  KingCosts(CL(buf[1]),CD(buf[2]),0,KingMat);
  i := 3; NK := 0;
  while(i<length(buf))do
    begin
      IP[i-3]:=CL(buf[i]);
      inc(i);
      IP[i-3]:=CD(buf[i]);
      inc(i);
      inc(NK);
    end;
end;

procedure InitData;
begin
  Erase(KingMat);
  ComputeKnightMats;
end;

begin
  InitData;
  ReadPieces(INFILE);
  MakePairs;
  Results(OUTFILE,Best)
end.
