(* Party Lamps - Miguel Mira da Silva *)

program lampsparty( input, output );

const
   MAXN = 100;
   MAXC = 100000;

var
  infile, outfile: text;                (* input & output files *)
  k, sum: integer;                      (* loop variables *)
  c1, c2, c3, c4 : integer;
  nlamps, counter: integer;             (* input: N-lamps; C-counter *)
  lampson: array [1..6] of integer;     (* input: lamps that are on *)
  lampsoff: array [1..6] of integer; (* input: lamps that are off *)
  lamp: array [1..6] of integer;        (* lamps 1 to 6 then it repeats *)
  canbe: boolean;                               (* to check lamps status *)

(************************************************************)

function even( n:integer ) : boolean;
  begin
  even := not odd ( N );
  end;

begin

  (************************************************************)

  assign( infile, 'input.txt' );
  reset( infile );

  readln( infile, nlamps );

  readln( infile, counter );

  read( infile, k );
  while k <> -1 do
    begin
    lampson[1 + (k-1) mod 6] := 1;
    read( infile, k );
    end;

  read( infile, k );
  while k <> -1 do
    begin
    lampsoff[1 + (k-1) mod 6] := 1;
    read( infile, k );
    end;

  close( infile );

  (************************************************************)

  assign( outfile, 'output.txt' );
  rewrite( outfile );
(*
  for k := 1 to 6 do
     writeln( outfile, 'lampson[', k, '] = ', lampson[k] );

  for k := 1 to 6 do
     writeln( outfile, 'lampsoff[', k, '] = ', lampsoff[k] );
*)
  for c1 := 0 to 1 do
  for c2 := 0 to 1 do
  for c3 := 0 to 1 do
  for c4 := 0 to 1 do

    begin

      sum := c1 + c2 + c3 + c4;

      if (sum <= counter) and (
           (even(counter) and even(sum)) or
           (odd(counter) and odd(sum)) ) then

        begin   

(*
        write( outfile, ' * nlamps = ', nlamps );
        write( outfile, ' * counter = ', counter );
        write( outfile, ' * c = ', c1, ' ', c2, ' ', c3, ' ', c4 );
        write( outfile, ' * sum = ', sum );
        write( outfile, ' *** ' );
*)
        lamp[1] := ( 1 + c1 + c2 + c4 ) mod 2;
        lamp[2] := ( 1 + c1 + c3 ) mod 2;
        lamp[3] := ( 1 + c1 + c2 ) mod 2;
        lamp[4] := ( 1 + c1 + c3 + c4 ) mod 2;
        lamp[5] := ( 1 + c1 + c2 ) mod 2;
        lamp[6] := ( 1 + c1 + c3 ) mod 2;

        canbe := true;
        for k := 1 to 6 do
          if ( (lamp[k] = 0) and (lampson[k] = 1) ) or
             ( (lamp[k] = 1) and (lampsoff[k] = 1) ) then
             canbe := false;

        if ( canbe = true ) then
          begin
          for k := 1 to nlamps do
            write( outfile, lamp[1 + (k-1) mod 6] );
(*          write( outfile, '(', (1 + (k-1) mod 6), ',', lamp[1 + (k-1) mod 6], ') ' ); *)
          writeln( outfile );
          end;

        end;

    end;

  close( outfile );

end.

