/**************************************************************************/
/**  Program sprawdzajacy zadanie 5 monet.                               **/
/**  Wersja udostepniana zawodnikowi.                                    **/
/**  Autor: Albert Krzymowski                                            **/
/**                                                                      **/
/**************************************************************************/

#include "umoneta.h"
#include "uwaga.h"
#include "usort.h"

#include <conio.h>

static char Key;                    /* ostatnio wcisniety klawisz     */
static int  Bylo[5];                /* czy i-ta moneta zostala podana */
static TMoneta Permutacja[5];       /* wczytywana permutacja          */
static short Wczytano;              /* ile monet juz podano           */

/*************************************************************************
  dodaj(TMoneta m)  - jesli m nie ma w permutacji to dodaje ja,
		      w p.p wyswietla komunikat z informacja.
**************************************************************************/

void dodaj(TMoneta m)
{

  if (Bylo[m]) {
    printf("%c juz bylo.\n", monetaToChar(m));
    return;
  }
  Bylo[m] = 1;
  Wczytano++;
  Permutacja[Wczytano - 1] = m;
  printf("%c\n",monetaToChar(m));
}


/***************************************************************************/
/* Wczytuje permutacje liter A,B,C,D,E z klawiatury.                       */
/*  Sprawdza czy podane litery na pewno tworza permutacje.                 */
/***************************************************************************/

static void WczytajPermutacje()
{
  TMoneta m;


  for (m = A; m <= E; m++)
    Bylo[m] = 0;

  Wczytano = 0;

  do {
    printf("Podaj monete nr %d>", Wczytano + 1);
    Key = getch();
    switch (Key) {

    case 'a':
    case 'A':
      dodaj(A);
      break;

    case 'b':
    case 'B':
      dodaj(B);
      break;

    case 'c':
    case 'C':
      dodaj(C);
      break;

    case 'd':
    case 'D':
      dodaj(D);
      break;

    case 'e':
    case 'E':
      dodaj(E);
      break;

    default:
      printf("\nNacisnij jeden z klawiszy: A B C D E <ESC>\n");
      break;
    }
  } while (Wczytano != 5 && Key != '\033');

}

void Intro()
{
 clrscr();
 printf(
"**************************************************************************\n");
 printf(
"* *                                                                    * *\n");
 printf(
"* *                         5  M O N E T                               * *\n");
 printf(
"* *                                                                    * *\n");
printf(
"**************************************************************************\n\n\n");

printf("\n\n  Podaj permutacje, na ktorej mam przetestowac rozwiazanie.\n");
}

/***************************************************************************/

void main()
{
  Intro();
  WczytajPermutacje();

  if (Wczytano != 5) {
    printf("Przerwano.\n");
    exit(0);
  }

  printf("\nTestuje na permutacji: %s\n\n",
	 monetyToStr(Permutacja[0], Permutacja[1],
		     Permutacja[2], Permutacja[3],
		     Permutacja[4]));

  WagaKolejnosc(Permutacja[0], Permutacja[1],
		Permutacja[2], Permutacja[3],
		Permutacja[4]);

  sortujMonety();
  if(IleRazyWynik == 0)
   printf("Twoja funkcja nie podala rozwiazania (wywolujac wynik(...) ).\n");
  printf("Koniec.\n");
}
