/***************************************************************************/
/* Rozwiazanie + sprawdzaczka zadania monety                               */
/* Modul: UWaga  - wersja udostepniana zawodnikowi.                        */
/* Plik : uwaga.c                                                                        */
/* Autor: Albert Krzymowski                                                */
/***************************************************************************/

#include "uwaga.h"

int IleRazyWynik;

static char InvPer[5];   /* inwersja permutacji jest wygodniejsza*/
static short ilePytan;

/*****************************************************************************/
/*  WagaUstaw - ustala permutacje, na ktorej bedziemy testowac               */
/*****************************************************************************/

void WagaKolejnosc(TMoneta m1,
		   TMoneta m2,
		   TMoneta m3,
		   TMoneta m4,
		   TMoneta m5)
{
  InvPer[m1] = 1;
  InvPer[m2] = 2;
  InvPer[m3] = 3;
  InvPer[m4] = 4;
  InvPer[m5] = 5;
  ilePytan = 0;
  IleRazyWynik = 0;
}


/*****************************************************************************/
/* lzejsza - funkcje z zadania, wyniku = true == Waga(m1) < Waga(m2)         */
/*****************************************************************************/

int lzejsza(TMoneta m1,
	    TMoneta m2)
{
  int Result;

  ilePytan++;
  printf("Porownanie nr: %d. ", ilePytan);
  printf("Czy %c < %c ? ", monetaToChar(m1), monetaToChar(m2));

  if (InvPer[m1] < InvPer[m2])
    {
      Result = 1;
      printf("Tak.\n");
    }
  else
    {
      Result = 0;
      printf("Nie\n");
    };

  if (ilePytan > 10)
    {
      printf("Wszystkich mozlosci porownan jest 10, to jest juz 11.\n");
      printf("Przerywam testowanie.\n");
      exit(0);
    }
  return Result;
}

/**************************************************************************/
/* wynik - przez ta procedure zawodnik podaje swaja odpowiedz.            */
/*  Musi zostac wywolana dokladnie jeden raz.                             */
/**************************************************************************/
void wynik(TMoneta m1,
	   TMoneta m2,
	   TMoneta m3,
	   TMoneta m4,
	   TMoneta m5)
{

  printf("\nPodano wynik: %s. \n", monetyToStr(m1, m2, m3, m4, m5));
  IleRazyWynik++;
  if (IleRazyWynik != 1) {
    printf("Procedure wynik wywolano wiecej niz jeden raz !\n");
    return;
  }
  if (InvPer[(long)m1] == 1 && InvPer[(long)m2] == 2 &&
      InvPer[(long)m3] == 3 && InvPer[(long)m4] == 4 && InvPer[(long)m5] == 5)
    printf("Brawo !!! Dobra odpowiedz.\n");
  else
    printf("Niestety, zla odpowiedz.\n");
}

