{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: ADDON                                          *}
{*   Plik:                ADD.PAS                                        *}
{*   Autor:               Albert Krzymowski                              *}
{*************************************************************************}


program addon;

{***********************************************************************}

{*                         S T A L E                                   *}

{***********************************************************************}

const

  CMAX_ILE_WYS    = 10000;

  CMAX_ILE_PRETOW = 10000;


  CPLIKWE = 'add.in';

  CPLIKWY = 'add.out';


{***********************************************************************}

{*                        T Y P Y                                      *}

{***********************************************************************}

type

  TDlg    = integer;


{*** Wezel drzewa binarnego ***}

 PDrzewo = ^TDrzewo;

 TDrzewo =  record

             lsyn :PDrzewo;

             psyn :PDrzewo;

             war  :TDlg;

            end;


var


{ ***   Stog (kopiec) dlugosci bezpiecznych reprezentowany

        za pomoca binarnego drzewa poszukiwan               ***}


Stog : PDrzewo;


{ ***   Tablica dlugosci pretow    ***}

Pret_Tab: array[1..CMAX_ILE_PRETOW] of TDlg;

Pret_Ile: 1..CMAX_ILE_PRETOW ;


{ *** Wysokosc komory ***}

WysokoscKomory     :TDlg;

IleDanych          :0..CMAX_ILE_WYS;


{ *** Pliki ****}

PlikWe      :text;

PlikWy      :text;


{ *** Pomoc ***}

I:longint;


{***********************************************************************}

{*   Obsluga stogu                                                     *}

{***********************************************************************}


procedure Stog_Wstaw(d:TDlg);


procedure wstaw(var p:PDrzewo);

 begin

  if p = nil then begin

                   new(p);

                   p^.lsyn:=nil;

                   p^.psyn:=nil;

                   p^.war :=d;

                  end

    else

      if p^.war > d then wstaw(p^.lsyn)

       else if p^.war < d then wstaw(p^.psyn);

 end;


begin

 wstaw(Stog);

end;



{**********************************************************************}



function Stog_Min:TDlg; {*** znalezienie i usuniecie elementu minimalnego ***}

 var

  pmin:PDrzewo;

  ojciec :PDrzewo;

 begin

  pmin:=Stog;

  ojciec:=nil;

  while pmin^.lsyn <> nil do

    begin

     ojciec:=pmin;

     pmin:=pmin^.lsyn;

    end;

  Stog_min:=pmin^.war;

  if ojciec = nil then {korzen}

                    Stog:=pmin^.psyn

                   else

                    ojciec^.lsyn:=pmin^.psyn;

  dispose(pmin);

 end;


{***********************************************************************}

{* Obluga tablicy pretow                                               *}

{***********************************************************************}


procedure Pret_Nowy(p:TDlg);

 begin

  Inc(Pret_Ile);

  Pret_Tab[Pret_Ile]:=p;

 end;



{***********************************************************************}

{* Nowe wysokosci slupkow powstale z postawienia na slupku dlg. p      *}

{* kazdego z pretow.                                                   *}

{***********************************************************************}


procedure ObliczNoweWysokosci(p:TDlg);

 var

  i:1..CMAX_ILE_PRETOW;

 begin

  for i:=1 to Pret_Ile do

   Stog_Wstaw(p + Pret_Tab[i]);

 end;


{***********************************************************************}

{* Glowna czesc programu                                               *}

{***********************************************************************}


procedure ObliczPrety;

 var

  aktWysokosc   :TDlg;      { rozwazana wyskosc }

  nastBezpieczna:TDlg;      { min z wyskosci, wiekszych od aktWyskosc, }

                            { ktore mozna ustawic z pretow w tablicy  }

  koniec        :boolean;


 procedure Przesun;

  begin

   WysokoscKomory:=aktWysokosc;

   ObliczNoweWysokosci(aktWysokosc);

   if IleDanych > 0 then

      begin

       Dec(IleDanych);

       Read(PlikWe,aktWysokosc)

      end

     else

      aktWysokosc:=0;

  end;



 begin

  Read(PlikWe,aktWysokosc);

  Dec(IleDanych);

  Pret_Nowy(aktWysokosc);

  Stog_Wstaw(aktWysokosc);

  Przesun;

  nastBezpieczna:=Stog_Min;

  nastBezpieczna:=Stog_Min;


  koniec:=false;


  while (aktWysokosc <> 0) and not koniec do

   begin

     if aktWysokosc > nastBezpieczna then koniec:=true

     else

      if aktWysokosc < nastBezpieczna then begin

                                            Pret_Nowy(aktWysokosc);

                                            Przesun;

                                           end

      else {if aktWysokosc = nastBezpieczna then}

       begin

        Przesun;

        nastBezpieczna:=Stog_Min;

       end;

   end;

 end;



{***********************************************************************}

{***********************************************************************}



begin

 Assign(PlikWe,CPLIKWE);

 Assign(PlikWy,CPLIKWY);

 Reset(PlikWe);

 Rewrite(PlikWy);

 Readln(PlikWe,IleDanych);

 ObliczPrety;


 Writeln(PlikWy,WysokoscKomory);


 for i:= 1 to Pret_Ile do

  Writeln(PlikWy,Pret_Tab[i]);


 Close(PlikWe);

 Close(PlikWy);

end.


