{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: ALIBABA                                        *}
{*   Plik:                ALI.PAS                                        *}
{*   Autor:               Marcin Kubica                                  *}
{*************************************************************************}


{ Algorytm polega na budowaniu i przeszukiwaniu wszerz grafu. Wezlami

  grafu sa "cwiartki" przestrzeni (tzn. punkty w przestrzeni mozliwych

  konfiguracji liczb zetonow, wieksze lub rowne od naroznika cwiartki),

  z ktorych mozna za pomoca wymian uzyskac konfiguracje otwierajaca

  sezam.


  Budowe i przeszukiwanie grafu rozpoczyna sie od cwiartki o

  narozniku bedacym konfiguracja otwierajaca sezam. W oczywisty sposob

  jesli ma sie tyle co trzeba lub wiecej zetonow, to mozna otworzyc

  sezam.


  Z cwiartki c mozna przejsc do cwiartki d jesli dla pewnej reguly r,

  cwiartka d zawiera dokladnie te konfiguracje, w ktorych mozna zastosowac

  r i w wyniku otrzymujemy konfiguracje nalezaca do cwiartki c.


  Zadanie sprowadza sie do sprawdzenia, czy z cwiartki wyznaczonej przez

  konfiguracje otwierajaca sezam mozna dojsc do cwiartki zawierajacej

  konfiguracje Alibaby.


  Budujac i przeszukujac graf mozna pominac cwiartki zawarte w juz

  wygenerowanych.


  Wszystkie wierzcholki w grafie maja skonczone stopnie oraz nie istnieje

  w nim nieskonczona sciezka (zlozona z cwiartek o malejacych lub

  niezaleznych wspolrzednych naroznikow) a wiec graf jest skonczony.

  }

const

  Wym    = 3;   { Wymiar. }

  MaxReg = 10;  { Maksymalna liczba regul. }


type

  punkt  = array [1..Wym] of longint;

           { Punkt w przestrzeni, wektor swobodny lub cwiartka przestrzeni. }

  lista  = ^ elem;

           { Lista cwiartek w przestrzeni. }

  elem   = record

             p    : punkt;   { Dolny naroznik cwiartki. }

             nkol : lista;   { Nastepny element kolejki przeszukiwania. }

             nos  : lista;   { Nastepny element listy wzajemnie niezaleznych

                               cwiartek reprezentujacych konfiguracje,

                               z ktorych mozna osiagnac sezam. }

             odl  : longint; { Odleglosc od cwiartki sezam. }

             sam  : boolean; { True gdy element jest tylko na jednej z list. }

           end;

  regula = record { Regula wymiany zetonow. }

             wez, daj : punkt

           end;


var

  nreg  : 1..MaxReg; { Liczba regul wymiany zetonow. }

  reg   : array [1..MaxReg] of regula; { Reguly wymiany zetonow. }

  osiag : lista; { Lista wzajemnie niezaleznych cwiartek, z ktorych mozna

                   osiagnac punkt koncowy (z atrapa). }

  kos   : lista; { Koniec listy osiag.  }

  kolej : lista; { Kolejka do przeszukiwania grafu wszerz (z atrapa). }

  kok   : lista; { Koniec listy kolej. }

  sezam : punkt; { Liczba zetonow potrzebnych do otwarcia Sezamu. }

  ali   : punkt; { Liczba zetonow, ktore ma Alibaba. }

  we, wy : text; { Pliki we, wy. }


procedure otworz;

{ Wczytuje dane }

var

  i, j : integer;

begin

  { Ile zetonow ma Alibaba. }

  for i := 1 to wym do

    read (we, ali [i]);

  { Ile zetonow otwiera Sezam }

  for i := 1 to wym do

    read (we, sezam [i]);

  { Reguly. }

  readln (we, nreg);

  for i := 1 to nreg do with reg[i] do begin

    for j := 1 to wym do

      read (we, wez [j]);

    for j := 1 to wym do

      read (we, daj [j])

  end;

end;



procedure Init;

{ Inicjuje listy osiag i kolej do obliczen. }

var

  c : lista;

begin

  { W 0 ruchach mozna wejsc do sezamu bedac tylko w cwiartce wyznaczonej

    przez sezam. }

  new (c);

  with c^ do begin

    p := sezam;

    nkol := nil;

    nos  := nil;

    odl  := 0;

    sam := false;

  end;

  { Atrapa. }

  new (kolej);

  osiag := kolej;

  with osiag^ do begin

    nkol := c;

    nos  := c;

    sam  := false

  end;

  kos := c;

  kok := c;

end;



function wr (a, b : punkt) : boolean;

{ Sprawdza, czy a jest wiekszy lub rowny b. }

var

  i : integer;

begin

  wr := true;

  for i := 1 to wym do

    if a [i] < b [i] then begin

      wr := false;

      exit

    end

end;


function osiagalne (p : punkt) : boolean;

{ Sprawdz, czy p jest zawarte w osiagalnych cwiartkach i usuwa cwiartki

  scisle zawarte w p. }

var

  o, op, on : lista;

  wyn : boolean;

begin

  wyn := false;

  o := osiag^.nos;

  op := osiag;

  { Sprawdz kolejne elementy listy osiag. }

  while (o <> nil) and not wyn do begin

    if wr (p, o^.p) then

      { p jest zawarte w o }

      wyn := true

    else if wr (o^.p, p) then begin

      { p jest mniejsze od o - usun o z osiag }

      op^.nos := o^.nos;

      if op^.nos = nil then kos := op;

      { Jesli nie wystepuje w kolejce, to zniszcz. }

      if o^.sam then

        dispose (o)

      else

        o^.sam := true;

      { Nastepny element. }

      o := op^.nos

    end else begin

      { Nastepny element. }

      op := o;

      o := o^.nos

    end

  end;

  { Wynik. }

  osiagalne := wyn

end;



procedure wstaw (pt : punkt; o : longint);

{ Wstawia cwiartke o zadanych wspolrzednych na liste osiag i kolej. }

var

  e : lista;

begin

  { Utworz element. }

  new (e);

  with e^ do begin

    p := pt;

    nkol := nil;

    nos := nil;

    odl := o;

    sam := false

  end;

  { Wstaw go do listy. }

  kos^.nos := e;

  kos := e;

  kok^.nkol := e;

  kok := e;

end;



procedure cwiartka (c : elem);

{ Rozpatruje cwiartki osiagalne w jednym kroku z cwiartki c. }

var

  r : 1..MaxReg;

  i : 1..Wym;

  d : punkt;

  e : lista;

begin

  with c do begin

    { Przejrzenie wszystkich regul. }

    for r := 1 to nreg do with reg [r] do begin

      { Cwiartka w ktorej mozna stosowac regule r i dojsc do wnetrza c. }

      for i := 1 to wym do

        if p [i] > daj [i] then

          d [i] := p [i] - daj [i] + wez [i]

        else

          d [i] := wez [i];

      { Cwiartka nie moze sie zawierac w c, ani byc juz osiagalna. }

      if not wr (d, p) then

        { Sprawdz czy d nie jest juz osiagalna i usun elementy wieksze od d. }

        if not osiagalne (d) then begin

          { Wstaw d do kolej i osiag. }

          wstaw (d, odl + 1)

        end

    end

  end

end;



procedure zniszcz;

{ Usuwa z pamieci wszystkie wskazniki. }

var

  p, pom : lista;

begin

  { Zniszcz liste osiag. }

  p := osiag;

  while p <> nil do begin

    pom := p;

    p := p^.nos;

    if pom^.sam then

      dispose (pom)

    else

      pom^.sam := true

  end;

  { Zniszcz liste kolej. }

  p := kolej;

  while p <> nil do begin

    pom := p;

    p := p^.nkol;

    if pom^.sam then

      dispose (pom)

    else

      pom^.sam := true

  end;

end;



function szukaj : lista;

{ Szuka sposobu wymiany zetonow, w przypadku powodzenia zwraca wskaznik

  do cwiartki zawierajacej Alibabe, w przypadku fiaska nil. }



var

  c : lista; { Aktualnie rozpatrywana cwiartka z kolejki. }

begin

  { Zainicjuj kolejki. }

  Init;

  { Przeszukiwanie wszerz grafu cwiartek. }

  while (kolej^.nkol <> nil) and not wr (ali, kolej^.nkol^.p) do begin

    { Wyjmij cwiartke z kolejki. }

    c := kolej^.nkol;

    kolej^.nkol := c^.nkol;

    if kolej^.nkol = nil then kok := kolej;

    { Rozpatrz wszystkie cwiartki osiagalne z c. }

    cwiartka (c^);

    { Jesli c zostalo usuniete z osiag to zniszcz c. }

    if c^.sam then

      dispose (c)

    else

      c^.sam := true;

  end;

  { Wynik. }

  szukaj := kolej^.nkol;

  zniszcz

end;



procedure wypisz (e : lista);

{ Wypisuje wynik zaleznie od wyniku poszukiwan. }

begin

  if e = nil then begin

    { Nie znaleziono konfiguracji. }

    writeln (wy, 'NIE')

  end else begin

    { Wypisz liczbe krokow. }

    writeln (wy, e^.odl)

  end;

end;



var

  d : integer;

begin

  assign (we, 'ALI.IN');

  reset (we);

  assign (wy, 'ALI.OUT');

  rewrite (wy);

  readln (we, d);

  for d := 1 to d do begin

    otworz;

    wypisz (szukaj);

  end;

  close (we);

  close (wy);

end.

