{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: GENOTYPY                                       *}
{*   Plik:                GEN.PAS                                        *}
{*   Autor:               Marcin Kubica                                  *}
{*************************************************************************}


{$M 32000, 0, 650000}

program geny;

{ Wersja z bitowa reprezentacja zbiorow genow, bez konstruowania list

  sklejanych zbiorow genow. }


const

  n        = 100; { Maksymalna dlugosc slowa }

  genmin   = 'A'; { Najmniejszy gen }

  genmax   = 'Z'; { Najwiekszy gen }

  ngen     = Ord(genmax) - Ord(genmin) + 1; { Liczba genow }

  supergen = 'S'; { Supergen }


type

  gen           = genmin .. genmax; { Pojedynczy gen }

  genotyp       = string [n];       { Genotyp }

  zbiorgenow    = longint;          { Zbior genow pamietany na bitach }

  produkcje     = array [gen, gen] of zbiorgenow;

                  { Macierzowa reprezentacja wszystkich
                    regul paczkowania (inaczej produkcji) }

  wyprowadzenia = array [1..n, 1..n] of zbiorgenow;

                  { Macierzowa reprezentacja genow, z ktorych da sie

                    wyprowadzic dane podslowo.

                    wyprowadzenia [i, j] to zbior genow, z ktorych

                    mozna wyprowadzic genotyp [i..j]. }


const

  { Kody singletonow poszczegolnych genow }

  genkod : array [gen] of zbiorgenow =

           (1 shl 0, 1 shl 1, 1 shl 2, 1 shl 3, 1 shl 4,

            1 shl 5, 1 shl 6, 1 shl 7, 1 shl 8, 1 shl 9,

            1 shl 10, 1 shl 11, 1 shl 12, 1 shl 13, 1 shl 14,

            1 shl 15, 1 shl 16, 1 shl 17, 1 shl 18, 1 shl 19,

            1 shl 20, 1 shl 21, 1 shl 22, 1 shl 23, 1 shl 24, 1 shl 25);


var

  prod   : produkcje;     { Tablica mozliwych produkcji }

  we, wy : text;

  w      : wyprowadzenia; { Tablica wyprowadzen podslow }


  { Otwiera pliki }

  procedure Otworz;

  begin

    assign (we, 'GEN.IN');

    reset (we);

    assign (wy, 'GEN.OUT');

    rewrite (wy)

  end;


  { Zamyka pliki }

  procedure Zamknij;

  begin

    close (we);

    close (wy)

  end;


  { Wczytuje z pliku wejsciowego dane o produkcjach i umieszcza je w

    tablicy produkcje }

  procedure Produkuj;

  var

    nn, x : integer;

    i, j, k : gen;

    p : string[3];

  begin

    { Wyzeruj tablica logiczna produkcji. }

    for i := genmin to  genmax do

      for j := genmin to genmax do

        prod [i, j] := 0;

    { Wczytaj dane do tablicy logicznej. }

    readln (we, nn);

    for x := 1 to nn do begin

      readln (we, p);

      prod [p[2], p[3]] := prod [p[2], p[3]] or genkod [p[1]]

    end

  end;


  { Na podstawie zbiorow genow, z ktorych da sie wyprowadzic lewe

    podslowo (lzb) oraz prawe podslowo (pzb) wyznacza zbior genow,

    z ktorych da sie wyprowadzic zlaczenie slow i wstawia je do

    zbioru zb. Korzysta z produkcji zakodowanych listowo w tablicy prod. }

  procedure Sklej (var zbl, zbp, zb : zbiorgenow);

  var

    g1, g2 : gen;                     { Indeksy par sklejanych genow }

  begin

    { Petla po parach sklejanych genow }

    for g1 := genmin to genmax do

      if zbl and genkod [g1] <> 0 then

        for g2 := genmin to genmax do

          if zbp and genkod [g2] <> 0 then

            begin

              { Dolaczenie genow wyprowadzalnych w sklejeniu g i z[i] }

              zb := zb or prod [g1, g2]

            end

  end;


  { Dla danego genotypu wylicz liczbe potrzebnych supergenow. }

  function Wyprowadz (gt : genotyp) : integer;

  const

    niema = n+1;

  var

    nn : integer;      { Dlugosc genotypu }

    s  : array [1..n] of 1..niema;

                       { Liczba potrzebnych supergenow dla uzyskania

                         podslow, niema = nie da sie wyprowadzic }

    i, j, k, m, x : integer;

  begin

    { Zainicjuj tablice wyprowadzen i wpisz genotyp na przekatna }

    nn := length (gt);

    for i := 1 to nn do

      w[i, i] := genkod [gt [i]];

    { Wylicz dynamicznie tablice wyprowadzen }

    for i := 1 to nn-1 do

      { i-ta nad-przekatna tablicy }

      for j := 1 to nn-i do begin

        { Element tablicy o wsp. [j, i+j] }

        { Wyzerowanie zbioru }

        w [j, i+j] := 0;

        for k:= 1 to i do begin

          { Sklejenie elementow o ws. [j, j+k-1] oraz [j+k, i+j] }

          sklej (w [j, j+k-1], w [j+k, i+j], w [j, i+j])

        end

      end;

    { Wylicz tablice minimalnych liczb potrzebnych supergenow. }

    for i := 1 to nn do begin

      {  s[i] = liczba supergenow potrzebnych do otrzymania genotypu [1..i] }

      if w [1, i] and genkod [supergen] <> 0 then begin

        { Cale podslowo jest wyprowadzalne z supergenu. }

        s [i] := 1

      end else begin

        { Wyliczenie dynamiczne liczby potrzebnych supergenow }

        m := niema;

        for k:= 2 to i do begin

          { Ostatni supergen wyprowadza genotyp [k..i] }

          if w [k, i] and genkod [supergen] <> 0 then begin

            x := s [k-1] + 1;

            if x < m then m := x

          end

        end;

        s [i] := m

      end

    end;

    { Wynik }

    if s [nn] = niema then

      Wyprowadz := 0

    else

      Wyprowadz := s [nn]

  end;


  { Wczytuje dane slowa i wypisuje dla nich wyniki }

  procedure Wylicz;

  var

    nn, i, wynik : integer;

    p : genotyp;

  begin

    { Obliczenia }

    readln (we, nn);

    for i := 1 to nn do begin

      readln (we, p);

      wynik := wyprowadz(p);

      if wynik = 0 then writeln (wy, 'NIE') else writeln (wy, wynik)

    end

  end;


begin

  Otworz;

  Produkuj;

  Wylicz;

  Zamknij

end.