{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: KAJAKI                                         *}
{*   Plik:                KAJ.PAS                                        *}
{*   Autor:               Marcin Mucha                                   *}
{*************************************************************************}



{ Program stosuje algorytm sortowania kubelkowego, a nastepnie            }

{ metode przeciwnych wag.                                                 }

{ Nie kompletuje oczywiscie kajakow po jednym, ale maksymalnie ile sie da.}

{ Tzn., jesli np. mamy W=100, 4 osoby o masie 10 i 3 osoby o masie 90,    }

{ to algorytm zliczy wszystkie trzy za jednym razem.                      }



const

   FILE_IN_NAME = 'kaj.in';

   FILE_OUT_NAME = 'kaj.out';


   MIN_WEIGHT = 5;

   MIN_WEIGHT_MINUS_1 = MIN_WEIGHT - 1; {Straznik.}

   MAX_WEIGHT = 200;

   MAX_WEIGHT_PLUS_1 = MAX_WEIGHT + 1;  {Straznik.}


var

   buckets : array[MIN_WEIGHT_MINUS_1..MAX_WEIGHT_PLUS_1] of word;

   { Kubelki w ktorych pamietamy ile jest osob o danej wadze. }

   file_in, file_out : text;

   w : word; { Maksymalne obciazenie kajakow. }



procedure open_file;

begin

   assign(file_in, FILE_IN_NAME);

   reset(file_in);

   assign(file_out, FILE_OUT_NAME);

   rewrite(file_out)

end;


procedure read_data;

var

   n,i,x : word;

begin

   for i:=MIN_WEIGHT_MINUS_1 to MAX_WEIGHT_PLUS_1 do

      buckets[i]:=0;

   readln(file_in, w);

   readln(file_in, n);

   for i:=1 to n do { Sortujemy kubelkowo przy wczytywaniu. }

      begin

         read(file_in, x);

         inc(buckets[x])

      end

end;


procedure count;

{ Procedura obliczajaca liczbe potrzebnych kajakow. }


function get_min(a,b : word) : word;

{ Funkcja zwracajaca minimum z dwoch liczb typu word. }

begin

   if a>=b then

      get_min:=b

   else

      get_min:=a

end;


var

   counter : word; { Licznik kajakow. }

   min : word; { Najmniejszy zapisany element w tablicy. }

   i,j : word; { Zmienne pomocnicze. }

begin

   { Szukamy najmniejszego niezerowego elementu w tablicy. }

   min:=MIN_WEIGHT;

   while buckets[min]=0 do inc(min);

   counter:=0;

   { Bedziemy kolejno dobierac partnerow dla najlzejszych osob. }

   while (min<MAX_WEIGHT) do

      begin

         if 2*min<=w then

         { Tylko wtedy dana osoba moze plynac z kims jeszcze. }

            begin

               i:=w-min; { Szukamy partnerow do kajakow. }

               while (buckets[i]=0) do dec(i);

               { Nastepna petla jest potrzebna bo moze sie zdarzyc ze }

               { nie starczy partnerow o tej samej wadze. }

               while (buckets[min]>0) and (i>min) do

                  begin

                     j:=get_min(buckets[min],buckets[i]);

                     dec(buckets[min],j);

                     dec(buckets[i],j);

                     inc(counter,j);

                     while (buckets[i]=0) and (i > MIN_WEIGHT_MINUS_1) do

                       dec(i)

                  end;

               { Moze byc tak ze zostana  osoby o wadze < w/2;          }

               { takie osoby mozna pogrupowac parami.                   }

               if buckets[min]>0 then

                  begin

                     inc(counter,(buckets[min]+1) div 2);

                     buckets[min]:=0;

                  end;

               while  (min<=MAX_WEIGHT) and (buckets[min]=0) do inc(min)

            end

         else

            begin

            { Pozostale osoby nalezy umiescic w kajakach pojedynczo. }

               while min<=MAX_WEIGHT do

                  begin

                     inc(counter,buckets[min]);

                     inc(min);

                  end

            end

      end;

   write(file_out, counter)

end;



procedure close_file;

begin

   close(file_out);

   close(file_in)

end;



begin

   open_file;

   read_data;

   count;

   close_file

end.