/*************************************************************************/
/*                                                                       */
/*                   IV Olimpiada Informatyczna                          */
/*                                                                       */
/*   Rozwiazanie zadania: LICZBA WYBOROW SYMETRYCZNYCH                   */
/*   Plik:                LIC.CPP                                        */
/*   Autor:               Grzegorz Jakacki                               */
/*************************************************************************/


/*

Szkic rozwiazania



Program znajduje liczbe sciezek w skierowanym grafie acyklicznym

reprezentujacym rozwiazania czesciowe.



$n$-te rozwiazanie czesciowe jest para $(p, s)$, gdzie $p$ i $s$ sa

odpowiednio prefiksem i sufiksem pewnych wyborow (niekoniecznie

symetrycznych), przy czym dlugosci (liczby liter) $p$ i $s$

wynosza $n$.



Program na poczatku inicjuje zmienne T, skok, nr_slowa, ileSlow i dlugosc

w nastepujacy sposob:



 ileSlow --- liczba wczytanych slow

 dlugosc --- dlugosc sumaryczna wszystkich wczytanych slow

 T[0..dlugosc-1] = x_1 y_1 x_2 y_2 ... x_n y_n

 nr_slowa[l] = nr_slowa[k]  wtw  T[l] i T[k] pochodza z tego samego slowa

 skok[l][0] = skok[l][ileSlow+1] = 0

 skok[0][k + 1] = l  wtw

	gdy l > 0	na pozycji k zaczyna sie jakies slowo $x$

				gdy l < 0	na pozycji k zaczyna sie jakies slowo $y$

 skok[1][k + 1] = l wtw

	gdy l > 0	na pozycji k konczy sie jakies slowo $x$

				gdy l < 0	na pozycji k konczy sie jakies slowo $y$



W drugiej fazie program przeszukuje graf rozwiazan czesciowych

(wierzcholki --- rozwiazania czesciowe, krawedz --- mozliwosc

rozszerzenia rozwiazania czesciowego).

Rozwiazanie czesciowe (p, s) jest reprezentowane za pomoca

pary (m, n), gdzie m --- indeks miejsca w tablict T z ktorego

pochodzi ostatnia litera p (odpowiednio: m --- pierwsza litera s).



Wierzcholki grafu utozsamia sie z rozwiazaniami czesciowymi,

a tym samym z parami (m, n). Dla oszczednosci pamieci korzysta

sie z faktu, ze m < n i stosuje adresowanie trojkatne,

tzn. roznowartosciowe odwzorowanie zbioru {(m, n) : 0 < m < n < K}

na zbior [0..L] dla pewnego L (zaleznego od K).



Rozszerzenie rozwiazania czesciowego (m, n) polega na przesunieciu

(zblizeniu) wskaxnikow m i n (to nie koniecznie jest zwykla

inkrementacja/dekrementacja). Rozwiazanie czesciowe moze byc

rozszerzone co najwyzej na cztery sposoby, stad stopien wejsciowy

i wyjsciowy dowolnego wierzcholka jest nie wiekszy niz 4.



Dla kazdego wierzcholka grafu przechowuje sie dwie wartosci:



(1)  Liczbe poprzednikow (2 bity)

(2)  Liczbe sciezek od wierzcholka poczatkowego (30 bitow)



Program oblicza najpierw wartosc (1), a nastepnie korzysta

z tej informacji do obliczenia wartosci (2). Obliczanie

jest realizowane metoda przechodzenia grafu za pomoca stosu.



Danych dla wierzcholkow koncowych (tj. wierzcholkow $(m, n)$ tz.

$m=n$ lub nastepnik n jest rowny m) nie przechowuje sie

w pamieci, lecz sumaryczna liczba prowadzacych do nich sciezek

zlicza sie od razu na zmiennej wyborySymetrzyczne.



Tablica potrzebna do przechowywania danych pomocniczych dla

grafu moze byc duza (do 79800 * 4 = 319200 B < 312 kB).

Zeby uninkac problemow z adresowaniem w trybie 8086,

tablie G przydziela sie stronami po 1995 long-int-ow

(1995*4 bajtow danych + 4 bajty dla systemu = 7984 bajty)

(maksymalnie 40 stron, co daje 40 * 7984 = 319360 < 312 kB).

*/

/* Ten program nalezy skompilowac w modelu Huge */


#include <stdio.h>
#include <stdlib.h>

/* maksymalna liczba par slow */

#define N 30

/* maksymalna sumaryczna dlugosc slow */

#define L 400

/* rozmiar strony */

#define STRONA 1995L

/* maksymalna potrzebna liczba stron*/

#define ILE_STRON_MAX 40L



int ileSlow;		/* liczba wczytanych slow */

int dlugosc;		/* sumaryczna dlugosc wczytanych slow */

FILE *plik;		/* plik (najpierw wejsciowym, potem wyjsciowy) */

unsigned long *G[ILE_STRON_MAX];

			/* wartosci pamietane w wierzcholkach grafu */

char T[L];		/* skonkatenowane slowa wejsciowe */

int skok[2][L + 2];	/* tablica pomocnicza do przechodzenia T */

int nr_slowa[L];		/* j.w. */

int stos[2 * L][2];	/* stos do przechodzenia grafu; na stosie bedzie

			 * co najwyzej tyle wolan rekurencyjnych,

												 * ile wynosi glebokosc grafu (bez wierzcholkow

												 * $(n, n)$) czyli $L/2$; na kazdym poziomie

												 * moga lezec co najwyzej 3 elementy + 1 na

			 * ostatnim poziomie; rozmiar $2L$ wystarczy

			 * z powodzeniem */

int sp;			/* wskaznik stosu */

unsigned long wyborySymetryczne;

			/* policzona liczba wyborow symetrycznych */



void czytajSlowa(char *buf)

/*

 * Wczytuje 'ileSlow' slow do bufora 'buf' (umieszczajac znak 0

 * po kazdym slowie) przy zalozeniu ze na zmiennej 'plik'

 * jest plik otwarty do czytania

 */

{

	int i,	/* indeks w buforze */

			j,	/* licznik slow */

			zn;	/* przeczytany znak */



	i = 0;

	j = 0;

	while (j < ileSlow)

	{

		zn = fgetc(plik);

		if (zn == '\n'  ||  zn == EOF)

		{

			zn = 0;

			j ++;

		}

		buf[i ++] = zn;

	}

}



void bladDanych()

/*

 * Zglasza blad w danych.

 */

{

	printf("Blad danych.\n");

	exit(1);

}



void czytaj()

/*

 * Inicjuje zmienne 'ileSlow', 'dlugosc', 'T', 'skok', 'nr_slowa'

 * danymi z pliku 'lic.in'

 */

{

	char pom[2][N + L];	/* bufor pomocniczy */

	int i[2],	/* indeksy dla slow $x$ i $y$ */

			j,	/* indeks w tablicy 'T' */

			k,        /* zm. pomocnicza */

			ktory,	/* z ktorego slowa jest kopiowane slowo */

			zostalo,	/* ile jeszcze slow zostalo do skopiowania */

			dl,	/* dlugosc skopiowanego slowa */

			pocz,	/* poczatek slowa w tablicy T */

			nrSl;	/* numer slowa, wpisywany do tablicy 'nr_slowa' */



	plik = fopen("lic.in", "r");

	if (plik == NULL) bladDanych();

	fscanf(plik, "%d", &ileSlow);

	if (ileSlow < 1  ||  ileSlow > N) bladDanych();

	/*

	 * przeczytaj znak '\n'

	 */

	fgetc(plik);

	/*

	 * do pom odczytaj slowa $x$ i $y$

	 */

	czytajSlowa(pom[0]);

	czytajSlowa(pom[1]);

	fclose(plik);

	/*

	 * kopiuj do T na przemian z pom[0] i pom[1] ustawiajac

	 * pola w tablicach

	 */

	ktory = 0;

	zostalo = ileSlow * 2;

	i[0] = 0;

	i[1] = 0;

	dl = 0;

	j = 0;

	while (zostalo > 0)

	{

		k = i[ktory];

		pocz = j;

		nrSl = ((zostalo + 1) / 2) * (1 - 2 * (zostalo % 2));

		while (pom[ktory][k])

		{

			T[j] = pom[ktory][k ++];

			nr_slowa[j] = nrSl;

			j ++;

		}



		dl = (j - pocz) * (1 - 2 * ktory);

		skok[0][pocz + 1] = dl;

		skok[1][j] = dl; /* zakladamy, ze slowa sa niepuste */

		i[ktory] = k + 1;

		ktory = 1 - ktory;

		zostalo --;

	}

	dlugosc = j;


	if (dlugosc > L) bladDanych();

}



long indeks(int w[2])

/*

 * Oblicza indeks pary 'w' w adresowaniu trojkatnym:

 *



	 w[0]:   0   1   2   3   4   5

			 -+-------------------------

w[1]: 0 |

			1 |  0

			2 |  1   2

			3 |  3   4   5

			4 |  6   7   8   9

			5 | 10  11  12  13  14

			6 | 15  16  17  18  19  20

 */

{

	return ((long) w[1] * ((long) w[1] - 1)) / 2 + (long) w[0];

}





/*

 * Trzy funkcje do operacji na atrybutach wierzcholka grafu

 * upakowanych w jednej liczbie 'unsigned long int'

 */

unsigned long inline rozpakujSciezki(unsigned long kod)

{

	return kod & 0x3FFFFFFF;

}



unsigned long inline rozpakujPoprzedniki(unsigned long kod)

{

	kod >>= 30;

	if (kod == 0) kod = 4;

	return kod;

}



unsigned long inline zapakuj(unsigned long p, unsigned long s)

{

	return (p << 30) | (s & 0x3FFFFFFF);

}



unsigned long &graf(long i)

/*

 * Zwraca referencje do komorki tablicy G przechowujacej atrybuty

 * wierzcholka o indeksie 'i'

 */

{

	return G[i / STRONA][i % STRONA];

}



int polKroku(int start[2], int wybor[2], int lp)

/*

 * Probuje rozszerzyc rozwiazanie czesciowe zadane w 'start'

 * przy uzyciu krawedzi grafu zadanej w 'wybor', z lewej lub prawej

 * strony, zaleznie od 'lp'.

 * Zwraca -1 jezeli nie jest to mozliwe.

 */

{

	int delta,	/* 1 lub -1, zaleznie od kierunku, w ktorym rozszerzane

								 * jest rozwiazanie */

			w;	/* zm. pomocnicza */



	delta = 1 - 2 * lp;

	w = start[lp] + delta;

	if (skok[lp][w + 1] * delta < 0) w -= skok[lp][w + 1];

	if (wybor[lp])

		if (skok[lp][w + 1] * delta > 0) w += skok[lp][w + 1];

		else w = -1;



	if (w < 0  ||  w >= dlugosc) w = -1;



  return w;

}



int krok(int start[2], int wybor[2], int wynik[2])

/*

 * Probuje rozszerzyc rozwiazanie czesciowe (z obu stron)

 * przy uzyciu krawedzi grafu zadanej w 'wybor'.

 * Zwraca 0, gdy nie mozna, 1 wpp. Jezeli sie da, to na

 * 'wynik' przypisuje nowe rozwiazanie czesciowe.

 */

{

	int w,	/* zm. pomocnicza */

      i;	/* indeks przebiegajacy kierunki (lewo/prawo) */



  for(i = 0; i < 2; i ++)

  {

    wynik[i] = polKroku(start, wybor, i);

    if (wynik[i] < 0) return 0;

   }



  if (wynik[0] > wynik[1]) return 0;



  return (T[ wynik[0] ] == T[ wynik[1] ])  &&

         (nr_slowa[ wynik[0] ] != - nr_slowa[ wynik[1] ]);

}



int koncowy(int wierzch[2])

/*

 * Zwraca 1 wtw wierzcholek 'wierzch' grafu jest wierzcholkiem koncowym.

 * 0 w p.p.

 */

{

  int wyb[2], nast[2], i;



  if (wierzch[0] == wierzch[1]) return 1;



  wyb[1] = 0;

	for(wyb[0] = 0; wyb[0] < 2; wyb[0] ++)

    if (polKroku(wierzch, wyb, 0) == wierzch[1]) return 1;



  return 0;

}



void przygotuj()

/*

 * Przydziela pamiec na atrybuty grafu i inicjalizuje wartosciami 1.

 */

{

  long i,	/* indeks */

       maks;	/* najwyzszy potrzebny adres */

	int w[2];	/* zm. pomocnicza */



  i = 0;

  w[0] = dlugosc - 2;

  w[1] = dlugosc - 1;

  maks = indeks(w);

  while (i < 401  &&  (i * STRONA <= maks))

  {

    if ((G[i] = new unsigned long[STRONA]) == NULL)

    {

      printf("Brak pamieci\n");

      exit(1);

    }

		i ++;

  }



  for(i = 0; i <= maks; i ++)

    graf(i) = 1;

}



void push(int w[2])

/*

 * Wklada element 'w' na stos

 */

{

  stos[sp][0] = w[0];

	stos[sp][1] = w[1];

  sp ++;

}



void pop(int w[2])

/*

 * Na 'w' przypisuje element zdjety ze szytu stosu.

 */

{

  sp --;

  w[0] = stos[sp][0];

  w[1] = stos[sp][1];

}



void liczSciezki(int pop[2], int w[2])

/*

 * Realizuje przejscie po sciezce 'pop'->'w' w algorytmie

 * obliczania liczby sciezek od wierzcholka poczatkowego

 */

{

  unsigned long k,	/* wartosc atrybutu okreslajacego liczbe

  			 * poprzednikow */

  		s;	/* wartosc atrybutu okreslajacego liczbe

                  	 * sciezek */



  if (koncowy(w))

		wyborySymetryczne += rozpakujSciezki(graf(indeks(pop)));

  else

  {

    k = rozpakujPoprzedniki(graf(indeks(w))) - 1;

    if (k == 0) push(w);

    s = rozpakujSciezki(graf(indeks(w)));

    if (pop[0] == -1) s += 1;

    else s += rozpakujSciezki(graf(indeks(pop)));

    graf(indeks(w)) = zapakuj(k, s);

  }

}



void liczPoprzedniki(int pop[2], int w[2])

/*

 * Realizuje przejscie po sciezce 'pop'->'w' w algorytmie

 * obliczania liczby poprzednikow

 */

{

  unsigned long k;	/* wartosc atrybutu okreslajacego liczbe

  			 * poprzednikow */



  if (!koncowy(w))

  {

    k = graf(indeks(w));

    if (k == 1)

    {

			push(w);

      k = 0;

    }

    k = rozpakujPoprzedniki(k) + 1;

    graf(indeks(w)) = zapakuj(k, 0);

  }

}



void dlaKazdegoNastepnika(int start[2], void akcja(int [2], int [2]))

/*

 * Wywoluje funkcje 'akcja' dla kazdego nastepnika wierzcholka

 * 'start' podajac jako parametry 'start' oraz numer nastepnika

 */

{

  int wyb[2],	/* indeksy wyboru krawedzi */

      wynik[2];	/* nastepnik */



  for(wyb[0] = 0; wyb[0] < 2; wyb[0] ++)

    for(wyb[1] = 0; wyb[1] < 2; wyb[1] ++)

      if (krok(start, wyb, wynik))

        akcja(start, wynik);

}



void przejdzGraf(void akcja(int *, int *))

/*

 * Realizuje przechodzenie grafu z uzyciem stosu. Dla kazdej

 * przechodzonej krawedzi jest wywolywana funkcja 'akcja'

 * z parametrami opisujacymi konce krawedzi.

 */

{

  int w[2];	/* wierzcholek poczatkowy aktualnie przechodzonych

  		 * krawedzi */

  sp = 0;

  w[0] = -1;

  w[1] = dlugosc;

  push(w);

  while (sp > 0)

  {

    pop(w);

		dlaKazdegoNastepnika(w, akcja);

  }

}





void main(void)

{

  czytaj();

  przygotuj();

  przejdzGraf(liczPoprzedniki);

  przejdzGraf(liczSciezki);

  plik = fopen("lic.out", "w");

  fprintf(plik, "%lu\n", wyborySymetryczne);

	fclose(plik);

}
