{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: LOTNISKA                                       *}
{*   Plik:                LOT.PAS                                        *}
{*   Autor:               Marcin Engel                                   *}
{*************************************************************************}

const

  MaxN = 500;  {*** maksymalna liczba miast ***}

type

  PElement = ^Element;


  Kolejka = record

              pier, ost: PElement; {*** wskazniki do pierwszego i ostatniego
                                        elementu w kolejce               ***}

            end;


  Element = record

              nr: integer;  {nr miasta}

              nast: PElement

            end;


{*** Operacje na kolejce ***}



procedure Put (var k: Kolejka; p: PElement);

{Wstaw nowy element na koniec kolejki}

begin

  with k do

  if pier = nil then { kolejka pusta }

  begin

     ost  := p;

     pier := p

  end else

  begin

    ost^.nast := p;

    p^.nast := nil;

    ost := p

  end

end;


function Get (var k: Kolejka): PElement;

{Pobierz i usun element z poczatku kolejki}

begin

  Get := k.pier;

  with k do

    if pier = ost then

    begin

      pier := nil;

      ost := nil

    end else

      pier := pier^.nast

end;



function First (k: Kolejka): PElement;

{Pobierz element z poczatku kolejki}

begin

  First := k.pier

end;


function Last (k: Kolejka): PElement;

{Pobierz element z konca kolejki}

begin

  Last := k.ost

end;


function Empty (k: Kolejka): boolean;

{Sprawdz, czy kolejka jest pusta}

begin

  Empty := (k.pier = nil);

end;



procedure Init (var k: Kolejka);

{Inicjacja pustej kolejki}

begin

  with k do

  begin

    pier := nil;

    ost := nil

  end

end;



var

  fin, fout: text;   {pliki wejsciowy i wyjsciowy}

  Q: array [1..MaxN] of Kolejka; {Q[d] --- kolejka lotnisk o przepustowosci d}

  n, {liczba miast}

  d, MaxD,  {d-przepustowosc, MaxD-maksymalna przepustowos}

  m, d2 : Integer; {zmienne pomocnicze}

  ostatni, pierwszy, p, r: PElement;


begin


  {otwarcie plikow}

  assign (fin, 'lot.in');

  reset (fin);

  assign (fout, 'lot.out');

  rewrite (fout);


  { inicjacja struktury danych }

  for d := 1 to MaxN do

    Init (Q[d]);

  MaxD := 0;


  { wczytanie danych i utworzenie kolejek lotnisk o danych przepustowsciach}

  readln (fin, n);  { wczytaj liczbe miast }

  for m := 1 to n do

  begin

    new (p);

    readln (fin, d);

    p^.nr := m;

    Put (Q[d], p);

    if d > MaxD then

      MaxD := d

  end;



  { przetwarzanie }

  d := MaxD;

  while d > 0 do

  begin  {wszystkie lotniska o przepustowosciach > d zostaly rozpatrzone}

    if Empty (Q[d]) then

      dec (d)

    else

    begin { mamy lotnisko o przepustwosci d i szukamy dla niego polaczen
            wsrod lotnisk o przepustowosciach <= d}

      p := Get (Q[d]);

      pierwszy := First (Q[d]);

      ostatni  := nil;

      m := d; d2 := d;

      while (d2 > 0) and (m > 0) do

      {dla miasta p^.nr szukamy polaczen do miast z kolejki Q[d2];
       miasto wskazywane przez ostatni jest pierwszym miastem w tej
       kolejce dla ktorego polaczenie z p^.nr zostalo juz ustalone}

        if First (Q[d2]) = ostatni then

        begin

          {kolejnych polaczen szukaj wsrod miast o mniejszych
           przepustowosciach}

          dec (d2);

          {pierwszy jest wskaznikiem do pierwszego miasta w Q[d2]
           polaczonego juz z p^.nr}

          if d2 > 0 then

          begin

            ostatni := pierwszy;

            if First (Q[d2]) = pierwszy then

              pierwszy := nil

            else

              pierwszy := First(Q[d2])

          end

        end else

        begin

          dec (m);

          r := Get (Q[d2]);

          writeln (fout, p^.nr, ' ', r^.nr);

          if d2 > 1 then

            Put (Q[d2-1], r)

        end

    end

  end;

  close (fout);

  close (fin);

end.

