{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: LOTNISKA                                       *}
{*   Plik:                LOT1.PAS                                       *}
{*   Autor:               Wojciech Guzicki                               *}
{*************************************************************************}



program Lotniska;

const
    MaxN = 501;     {O 1 wiecej niz maksymalna liczba miast,    }
                    {by nie przekroczyc zakresu tablicy.        }

type
    Lotnisko = record
                   Numer, d : integer {Numer i przepustowosc lotniska.}
               end;

    Tablica  = array [1..MaxN] of Lotnisko;

var

    T : Tablica;
    n : integer; {Liczba lotnisk.}

procedure Wczytaj;
    var
        Plik : Text;
        i : integer;
    begin
        assign(Plik,'LOT.IN');
        reset(Plik);
        readln(plik,n);
        for i:=1 to n do begin
            T[i].Numer:=i;
            readln(Plik,T[i].d)
        end;
        T[n+1].Numer:=0;    {Wartownik.}
        T[n+1].d:=-1; {Wartownik.}
        close(Plik)
    end; {Wczytaj}

procedure Zamien (i,j : integer);
    { W tablicy T zamienia lotniska o numerach i, j. }
    var
        Pom : Lotnisko;
    begin
        Pom:=T[i];
        T[i]:=T[j];
        T[j]:=Pom
    end; {Zamien}

procedure QuickSort;
    { Sortuje tablice numerow i przepustowosci lotnisk. }
    {Procedura przepisana z ksiazki Wirtha:     }
    {  Algorytmy + struktury danych = programy. }
    procedure Sort (l,p : integer);
        var
            i,j : integer;
            x   : Lotnisko;
        begin
            i:=l; j:=p;
            x:=T[(l+p) div 2];
            repeat
                while T[i].d>x.d do i:=i+1;
                while T[j].d<x.d do j:=j-1;
                if i<=j then begin
                    Zamien(i,j);
                    i:=i+1; j:=j-1
                end
            until i>j;
            if l<j then Sort(l,j);
            if i<p then Sort(i,p)
        end; {Sort}
    begin
        Sort(1,n)
    end; {QuickSort}

procedure Wypisz;
    var
        Plik : Text;
        Pom  : Tablica; {Tablica pomocnicza do zamiany.}
        Nr   : integer; {Numer aktualnie badanego lotniska.}
        d_akt   : integer; {Przepustowsc aktualnie badanego lotniska.}
        Nr1  : integer; {Numer ostatniego lotniska, ktoremu}
                        {zmniejszylismy przepustowosc.     }
        Nr2  : integer; {Nr1+1.                              }
        NrL  : integer; {Numer ostatniego lotniska, ktore ma       }
                        {przepustowosc wieksza od ostatniej, ktora}
                        {zmniejszylismy.                           }
        NrP  : integer; {Numer pierwszego lotniska, ktore ma }
                        {przepustowosc mniejsza od ostatniego,     }
                        {ktore ma za duza przepustowosc.           }
        L,P  : integer; {liczby lotnisk, ktore trzeba zamie- }
                        {nic po zmniejszeniu przepustowsci.         }
        i    : integer; {indeks...                           }
    begin
        assign(Plik,'LOT.OUT');
        rewrite(Plik);
        for Nr:=1 to n do
            if T[Nr].d>0 then begin
                {Bedziemy zmniejszac przepustowosci...              }
                d_akt:=T[Nr].d;
                for i:=1 to d_akt do begin
                    T[Nr+i].d:=T[Nr+i].d-1;
                    writeln(Plik,T[Nr].Numer,' ',T[Nr+i].Numer)
                    {... zmniejszylismy i zapisalismy...     }
                end;
                Nr1:=Nr+d_akt;
                if T[Nr1].d<T[Nr1+1].d then begin
                    {... okazalo sie, ze trzeba ponownie     }
                    {posortowac; zliczamy lotniska z lewej   }
                    {i z prawej strony, by wiedziec, w jakiej}
                    {kolejnosci i ile zamienic...            }
                    NrL:=Nr1;
                    while T[NrL].d=T[Nr1].d do
                        NrL:=NrL-1;
                    L:=Nr1-NrL;
                    {Tyle jest z lewej strony...             }
                    Nr2:=Nr1+1;
                    NrP:=Nr2;
                    while T[NrP].d=T[Nr2].d do
                        NrP:=NrP+1;
                    P:=NrP-Nr2;
                    {... a tyle z prawej strony.             }
                    if L<P then begin
                        {Mniejsza ilosc zapisujemy w tablicy }
                        {pomocniczej, tyle samo z drugiej    }
                        {strony wpisujemy na wlasciwe miejsce}
                        {i wtedy wpisujemy z tablicy pomocn. }
                        for i:=1 to L do
                            Pom[i]:=T[NrL+i];
                        for i:=1 to L do
                            T[NrL+i]:=T[NrP-i];
                        for i:=1 to L do
                            T[NrP-i]:=Pom[i]
                    end else begin
                        {Jak wyzej, ale tym razem mniej jest }
                        {z prawej strony.                    }
                        for i:=1 to P do
                            Pom[i]:=T[NrP-i];
                        for i:=1 to P do
                            T[NrP-i]:=T[NrL+i];
                        for i:=1 to P do
                            T[NrL+i]:=Pom[i]
                    end
                end
            end;
        close(Plik)
    end;

begin
    Wczytaj;
    QuickSort;
    Wypisz;
end.
