{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: LOTNISKA                                       *}
{*   Plik:                LOT2.PAS                                       *}
{*   Autor:               Marcin Engel                                   *}
{*************************************************************************}




{ Ponizszy program umozliwia eksperymenty z roznymi algorytmami sortowania}


program Lot2;

const

  MaxN = 500;

type

  opis = record

           miasto: integer;

           d: integer  {przepustowosc}

         end;

var

  lotniska : array [0..MaxN] of opis;

  n, m, i, ilemniej, odpoz, dopoz: integer;

  fin, fout: text;


procedure InsertionSort (odpoz, dopoz: integer);

{sortowanie przez wstawianie lotniska[odpoz..dopoz]}

var

  x: opis;

  i, j : integer;

begin

  for i := odpoz+1 to dopoz do

  begin

    x := lotniska[i];

    lotniska[odpoz-1]:=x;

    j := i - 1;

    while lotniska[j].d > x.d do

    begin

      lotniska[j+1] := lotniska[j];

      dec (j)

    end;

    lotniska[j + 1] := x;

  end

end;


procedure SelectionSort (odpoz, dopoz: integer);

{sortowanie przez wybor lotniska[odpoz..dopoz]}

var

  x, i, j : integer;

  pom: opis;

begin

  for i := odpoz to dopoz-1 do

  begin

    x := i;

    for j := i+1 to dopoz do

      if lotniska [j].d < lotniska [x].d then

        x := j;

    pom := lotniska [i];

    lotniska [i] := lotniska [x];

    lotniska [x] := pom;

  end

end;


procedure QuickSort (odpoz, dopoz : integer);

{sortowanie szybkie lotniska[odpoz..dopoz]}

var

  x, pom: opis;

  l, r : integer;

begin

  l := odpoz; r := dopoz;

  if r - l <> 0 then

  begin

    x := lotniska [l];

    while l < r do

      if lotniska [l].d < x.d then

        inc (l)

      else

      if lotniska [r].d >= x.d then

        dec (r)

      else

      begin

        pom := lotniska [l];

        lotniska [l] := lotniska [r];

        lotniska [r] := pom;

        inc (l);

        dec (r)

      end;

      if lotniska[r].d > x.d then r := r -1 ;

      QuickSort (odpoz, r);

      QuickSort (r+1, dopoz)

  end;

end;


procedure Merge (l, m, r : integer);


{ Procedura laczy podciagi posortowane znajdujace sie w A w miejscu

  odpowiednio: l do m i m+1 do r wlacznie przy uzyciu dodatkowej pamieci

  roboczej. }

var

  B : array [0..MaxN] of opis;

  i, j, k : integer;

begin

  i := l;

  j := m+1;

  k := 1;

  while (i<=m) and (j<=r) do

    if lotniska [i].d <= lotniska [j].d then

    begin

      B [k] := lotniska [i];

      inc (k);

      inc (i)

    end else

    begin

      B [k] := lotniska [j];

      inc (k);

      inc (j)

    end;

  while i<=m do

  begin

    B [k] := lotniska [i];

    inc (i);

    inc (k)

  end;

  while j<=r do

  begin

    b [k] := lotniska [j];

    inc (j);

    inc (k)

  end;

  for i := 1 to k-1 do

    lotniska [l+i-1] := B [i] ;

end; { MergeSort }



procedure MergeSort (odpoz, dopoz : integer);

{ sortowanie przez scalanie lotniska[odpoz..dopoz]}

var

  m :integer;

begin

  if odpoz <> dopoz then

  begin

    m := (odpoz+dopoz) div 2;

    MergeSort (odpoz, m);

    MergeSort (m+1, dopoz);

    Merge (odpoz, m, dopoz)

  end

end;



procedure BubbleSort (odpoz, dopoz: integer);

{ sortowanie babelkowe lotniska[odpoz..dopoz]}

var

  i, j : integer;

  pom : opis;

begin

  for i := odpoz+1 to dopoz do

    for j := dopoz downto i do

      if lotniska [j].d < lotniska [j-1].d then

      begin

        pom := lotniska [j];

        lotniska [j] := lotniska [j-1];

        lotniska [j-1] := pom;

      end

end;


begin

  { otwarcie plikow }

  assign (fin, 'lot.in');

  reset (fin);

  assign (fout, 'lot.out');

  rewrite (fout);

  { wczytanie danych }

  readln (fin, n);

  for m := 1 to n do

    with lotniska[m] do

    begin

      miasto := m;

      readln (fin, d)

    end;

  odpoz := 1; dopoz := n;

  QuickSort (odpoz, dopoz); {tu mozesz wstawic inna procedure sortujaca}

  while odpoz < dopoz do

  begin

    ilemniej := 0;

    for i := 1 to lotniska[dopoz].d do

    begin

      dec (lotniska[dopoz-i].d);

      if lotniska[dopoz-i].d = 0 then inc (ilemniej);

      writeln (fout, lotniska[dopoz].miasto, ' ', lotniska[dopoz-i].miasto);

    end;

    dec (dopoz);

    InsertionSort (odpoz, dopoz); {tu mozesz wstawic inna procedure sortujaca}

    inc (odpoz, ilemniej);

  end;

  close (fin);

  close (fout)

end.