{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: PALIWO                                         *}
{*   Plik:                PAL.PAS                                        *}
{*   Autor:               Albert Krzymowski                              *}
{*************************************************************************}


program Paliwo;


 const

  CMAX_CENA     =  1000;

  CMAX_BAK      =  1000000;

  CMAX_STACJI   =  1000000;

  CMAX_DYSTANS  =  1000000;


  CPLIK_WE      = 'pal.in';

  CPLIK_WY      = 'pal.out';


 type

  TCena             = 1..CMAX_CENA;

  TBAK              = 0..CMAX_BAK;

  TDystans          = 0..CMAX_DYSTANS;

  TGotowka          = 0..CMAX_DYSTANS*CMAX_CENA;

 var

  Ceny              : array[TCena] of 0..CMAX_BAK+CMAX_DYSTANS;

                        { do ktorego kilometra mozemy korzystac z benzyny }

                        { o danej cenie }

  PozostaloStacji   : 0..CMAX_STACJI;

  PojBaku           : TBak;

  PlikWe            : text;

  PlikWy            : text;


{************************************************************************}

{* InitPaliwo - inicjalizacja                                           *}

{************************************************************************}


 procedure InitPaliwo;

  var

   i:TCena;

  begin

   Assign(PlikWe,CPLIK_WE);

   Reset(PlikWe);

   Readln(PlikWe,PojBaku);

   Readln(PlikWe,PozostaloStacji);


   for i := 1 to CMAX_CENA do

    Ceny[i]:=0;

  end;


{************************************************************************}

{* obliczGotowke - oblicza najtanszy koszt przejazdu                     *}

{************************************************************************}



 function obliczGotowke:TGotowka;

  var

   gotowka           : TGotowka;

   doNastepnejStacji : TDystans;

   min               : TCena;

   skok              : TDystans;

   mila          : Tdystans; {rozwazany odcinek}


{************************************************************************}

{* znajdzNajtansza - szuka najtanszej dostepnej benzyny                 *}

{************************************************************************}


  function znajdzNajtansza:TCena;

  var

   i:TCena;

  begin

   i:=1;

   while Ceny[i] <= mila do

    Inc(i);

   znajdzNajtansza:=i;

  end;

{************************************************************************}

{* jedz - przesuwamy samochod o "dystans"                                *}

{************************************************************************}


  function jedz(dystans:TDystans):boolean;

  var

   cena: TCena;

  begin

    mila:=mila+dystans;

    doNastepnejStacji := doNastepnejStacji - dystans;



    if (doNastepnejStacji = 0) and (PozostaloStacji > 0) then

     begin

      Readln(PlikWe,cena,doNastepnejStacji);

      Ceny[cena]:=mila+PojBaku;

      Dec(PozostaloStacji);

     end;



    jedz:=(PozostaloStacji > 0) or (doNastepnejStacji <> 0);

   end;



 begin

  gotowka:=0;

  mila:=0;

  Readln(PlikWe,min,doNastepnejStacji);

  Ceny[min]:=PojBaku;

  Dec(PozostaloStacji);



  repeat

   min := znajdzNajtansza;

   if mila+doNastepnejStacji < Ceny[min] then

      skok:=doNastepnejStacji

     else

      skok:=Ceny[min]-mila;

   gotowka := gotowka+min*skok;

  until not jedz(skok);



  obliczGotowke:=gotowka;

 end;


{************************************************************************}


begin

 InitPaliwo;

 Assign(PlikWy,CPLIK_WY);

 Rewrite(PlikWy);

 Writeln(PlikWy,obliczGotowke);

 Close(PlikWy);

 Close(PlikWe);

end.
