{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: REKURENCYJNA MROWKA                            *}
{*   Plik:                REK.PAS                                        *}
{*   Autor:               Krzysztof Sobusiak                             *}
{*************************************************************************}


program Mrowka;

const MAXM = 50;   { max. liczba pol zabronionych }

      MAXPOZIOM = 3;  { max. k takie, ze jedna z cwiartek }

                      { szachownicy 2^k x 2^k moze byc }

                      { w calosci pokryta przez pola zabronione }

                      { czyli max. k ze (4^k)/4<=MAXM }

      MAXN = 30;  { max. rozmiar szachownicy }

var Zabron : array [1..MAXM] of record  { pola zabronione }

                                  x,y  : LongInt;  { wspolrzedne }

                                  nast : Byte   { nastepne pole w liscie }

                                end;

    n,m : Byte;



procedure WczytajDane(var F : Text);

var i : Byte;

begin

  Readln(F,n,m);

  for i:=1 to m do

    Readln(F,Zabron[i].y,Zabron[i].x)

end;



{ kodowanie cwiartek i kierunkow :

                    0
              Ŀ
                0    1  
            3 Ĵ 1
                3    2  
              
                    2

}



function Droga(poziom : Byte;

               we,wy : Byte;

               wsp : LongInt;

               zabr : Byte) : LongInt;

{ zwraca poprawna droga na szachownicy rozmiaru 2^poziom }

{ przy wejsciu z kierunku we i wyjsciu na brzegu wy }

{ i polach zabronionych na liscie zabr, }

{ wsp oznacza wspolrzedna pola startowego }

{ jej rodzaj (x czy y) okreslone jest przez we }

{ druga wspolrzedna nie jest nam potrzebna }

const XY2Cw : array [Boolean,Boolean] of Byte = ((0,3),(1,2));

               { kod cwiartki w zaleznosci od x i y }

var Cwiartki : array [0..3] of record { podzial pol zabronionych na cwiartki }

                                 l : Byte;  { liczba pol }

                                 zabr : Byte { lista pol }

                               end;

    cwpocz : Byte;  { cwiartka, w ktorej lezy pole startowe }

    pelne : Byte;   { liczba cwiartek w calosci zabronionych }

    pot : Byte;     { liczba pol w cwiartce }

    polowa : LongInt;  { polowa dlugosci szachownicy }

    nast,c,i : Byte;



  function Probuj(kier : Byte) : Boolean;

  { probujemy obejsc cwiartki w kierunku kier (1 - w prawo, 3 - w lewo }

  var wwe,wwy : Byte; { we i wy dla kolejnych cwiartek }

      cw : Byte;      { kolejna cwiartka }

      k,i : Byte;

  begin

    Probuj:=False;

    cw:=(cwpocz+(4-pelne-1)*kier) and 3; { cwiartka koncowa }

    if (cw<>wy) and ((cw+3) and 3<>wy) { czy mozemy wyjsc na brzegu wy? }

      then Exit;

    cw:=cwpocz;

    for i:=1 to 4-pelne do  { po drodze nie mozemy miec cwiartek }

                            { w calosci zabronionych }

      begin

        if Cwiartki[cw].l=pot

          then Exit;

        cw:=(cw+kier) and 3

      end;

    Probuj:=True;

    cw:=cwpocz;

    wwe:=we;

    if kier=1

      then wwy:=(cwpocz+1) and 3

      else wwy:=(cwpocz+2) and 3;

    { no to idziemy }

    for i:=1 to 4-pelne-1 do

      begin

        wsp:=Droga(poziom-1,wwe,wwy,wsp,Cwiartki[cw].zabr);

        if wsp=-1

          then Exit;

        wwe:=wwy xor 2;

        wwy:=(wwy+kier) and 3;

        cw:=(cw+kier) and 3

      end;

    wsp:=Droga(poziom-1,wwe,wy,wsp,Cwiartki[cw].zabr);

    if wsp=-1

      then Exit;

    if (wy<2) xor (cw=wy) { wyszlismy w dolnej, czy gornej }

      then Inc(wsp,polowa)   { polowie brzegu? }

  end;



begin

  if poziom=0  { pojedyncze pole }

    then begin

           Droga:=0;

           Exit

         end;

  polowa:=LongInt(1) shl (poziom-1);

  if zabr=0  { szachownica bez pol zabronionych }

    then begin

           if (we=wy) or (we xor wy=3)

             then Droga:=2*polowa-1-wsp

             else Droga:=wsp;

           Exit

         end;

  FillChar(Cwiartki,SizeOf(Cwiartki),0);

  while zabr<>0 do  { dzielimy liste pol zabronionych pomiedzy cwiartki }

    begin

      c:=XY2Cw[Zabron[zabr].x and polowa<>0,Zabron[zabr].y and polowa<>0];

      nast:=Zabron[zabr].nast;

      Zabron[zabr].nast:=Cwiartki[c].zabr;

      Inc(Cwiartki[c].l);

      Cwiartki[c].zabr:=zabr;

      zabr:=nast

    end;

  if poziom<=MAXPOZIOM

    then pot:=1 shl (2*(poziom-1))

    else pot:=255;

  pelne:=0;

  for c:=0 to 3 do  { liczymy ile jest cwiartek w calosci zabronionych }

    if Cwiartki[c].l=pot

      then Inc(pelne);

  cwpocz:=(we+Ord((wsp>=polowa) xor (we>=2))) and 3;

  wsp:=wsp and (polowa-1);

  if not Probuj(1) and { sprawdzimy rekurencyjnie najwyzej jedna mozliwosc }

     not Probuj(3)  { w zaleznosci od ukladu cwiartek w calosci zabronionych }

    then Droga:=-1

    else Droga:=wsp

end;



function Rozwiaz(wy : Byte) : LongInt;

{ znajduje wspolrzedna pola koncowego przy wyjsciu mrowki na brzegu wy }

var i,z : Byte;

begin

  if m>0

    then begin

           for i:=1 to m-1 do   { inicjujemy liste pol zabronionych }

             Zabron[i].nast:=i+1;

           Zabron[m].nast:=0;

           z:=1

         end

    else z:=0;

  Rozwiaz:=Droga(n,0,wy,0,z) { startujemy w polu (0,0) }

end;



var i : Byte;

    wsp : LongInt;

    F : Text;

begin

  Assign(F,'rek.in');

  Reset(F);

  WczytajDane(F);

  Close(F);

  Assign(F,'rek.out');

  Rewrite(F);

  for i:=0 to 3 do

    begin

      wsp:=Rozwiaz(i);

      if wsp>=0

        then begin

               case i of

                 0 : Write(F,0,' ');

                 2 : Write(F,LongInt(1) shl n-1,' ')

               end;

               Write(F,wsp);

               case i of

                 1 : Write(F,' ',LongInt(1) shl n-1);

                 3 : Write(F,' ',0)

               end;

               Writeln(F)

             end

        else Writeln(F,'NIE')

    end;

  Close(F)

end.

