{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: REZERWACJA SAL WYKLADOWYCH                     *}
{*   Plik:                REZ.PAS                                        *}
{*   Autor:               Tomek Blaszczyk                                *}
{*************************************************************************}

program rez;


const MAXN = 10000;

      INNAME = 'rez.in';

      OUTNAME = 'rez.out';


type TRekord = record  Pocz, Kon: word end;


var T: array[0..MAXN] of TRekord;

      {W tablicy T przechowujemy dane posortowane niemalejaco wzgledem

       czasu zakoczenia}

    Czas: array[0..MAXN] of WORD;

      { czas bedzie obliczany dynamicznie}

    n: word;      {rozmiar wczytanych danych}

{*********************************************************

 * Wczytuje danych do tablicy T.

 *********************************************************}

procedure wczytaj_dane;

var i: word;  {zmienna pomocnicza}

    f: text;  {plik wejsciowy}

begin

   assign(f,INNAME); reset(f); {Otworz plik wejsciowy.}

   readln(f,n);  {Wczytaj rozmiar danych.}

   for i:=1 to n do  {Wczytuj dane z pliku.}

      with t[i] do

         readln(f,pocz,kon);

   close(f);  {Zamknij plik.}

end;


{***************************************************************

 * Sortowanie (HeapSort) tablicy po wspolrzednej 'kon'.

 ***************************************************************}

procedure sortuj;

var i: word;          {Zmienna uzywana w petlach for.}

    tmp:  TRekord;    {pomoc - tu zapisujemy element,

                       ktory opuszczamy w dol.}

    rozm: word;   {Aktualny rozmiar stogu.}


   procedure element_w_dol ( k: word ); {Indeks opuszczanego elementu.}

   var j: word;     {Indeks dziecka elementu k.}

       klucz: word; {tmp.kon, czyli to, z czym porownujemy

                      kolejne elementy.}


   begin

        {Na tmp jest element, ktory opuszczamy w dol.}

      klucz := tmp.kon;

        {A teraz na klucz jest wlasciwa wartosc do porownania;

          wprowadzone tylko w celu przyspieszenia obliczen.}

      while k<=(rozm shr 1) do begin

            {Dopoki miescimy sie w stogu, sprawdzamy dzieci.}

         j := (k shl 1);  {j jest lewym synem k, j=2*k.}

         if j<rozm then {Jesli k ma tez prawego syna}

            if t[j].kon<t[j+1].kon then {i jest on wiekszy od lewego,}

               j:=j+1; {to bedziemy porownywac ojca z prawym synem.}

         {W p.p. na j jest indeks lewego - wiekszego lub jedynego syna.}

         if klucz>t[j].kon then break; {tmp nalezy wstawic na pozycji k.}

         t[k] := t[j]; {W przeciwnym razie przesuwamy syna j
                        na miejsce ojca ...}

         k := j; {...i opuszczamy sie na miejsce syna.}

      end;

      t[k] := tmp;  {Umieszczamy tmp na znalezionym miejscu.}

   end; {of procedure element_w_dol}

begin

   rozm := n;  {Stog jest pelnej wielkosci.}

    {Tworzymy stog n-elementowy.}

   for i:=(n shr 1) downto 1 do begin

      tmp := t[i];

      element_w_dol(i);

   end;

   {Teraz usuwamy kolejno najwieksze elementy z wierzcholka stogu.}

   for i:=n downto 2 do begin

      tmp := t[i];

      t[i] := t[1];

      rozm := i-1;

      element_w_dol(1);

   end;

      {Ciag jest posotrowany.}

end;


{*************************************************************************

 * Funkcja szuka najwczesniejszego takiego zamowienia,ktory konczy sie pozniej

 * niz t_rozp lub zwraca 1 jesli takiego zapisu nie ma.

 * W kazdym razie mamy pewnosc, ze znajdz_indeks-1 jest najpozniejszym

 * wykladem, ktory sie konczy w czasie <= t_rozp,

 * przy zalozeniu, ze t[0].kon=-1.

 *************************************************************************}

function znajdz_indeks ( t_rozp: word; l, r: word): word;

var s: word;

begin

   while l<r do begin

      s:=(l+r) div 2;

      if t[s].kon>t_rozp then

         r:=s

      else

         l:=s+1;

   end;

   znajdz_indeks:=l;

end;


{**************************************************************************

 * Procedura oblicza najlepsze czasy dla kolejnych elementow tablicy.

 **************************************************************************}

procedure obliczaj;

var i, j: integer;

    t1, t2: word;

begin

   czas[0] := 0;

      {Aby nie komplikowac, zakladamy ze czas[0]=0.}

   czas[1] := t[1].kon - t[1].pocz;

      {czas[1] liczymy od razu,}

     {a potem liczymy pozostale czasy:}

   for i:=2 to n do begin

      t1 := czas[i-1];

         {Najlepszy czas, jesli nie dolaczamy i-tego zamowienia t[i].}

      j := znajdz_indeks ( t[i].pocz, 1, i );

      t2 := czas[j-1] + (t[i].kon - t[i].pocz );

        {Najlepszy czas, jesli jednak dolaczamy i-ty element.}

      if t1>t2 then czas[i] := t1

      else czas[i] := t2

         {Wybieramy lepszy czas i zapisujemy go.}

   end {of for}

end;


{**************************************************************************

 * Procedura zapisuje wynik na dysk.

 **************************************************************************}

procedure wypisz_wynik;

var f: text;

begin

   assign(f,OUTNAME); rewrite(f);

   writeln(f,czas[n]);

   close(f);

end;


{*************************************************

 * Program glowny.

 *************************************************}

begin

   wczytaj_dane;

   czas[0]:=0;

   sortuj;

   obliczaj;

   wypisz_wynik

end.

