{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: SKOK W BOK                                     *}
{*   Plik:                SKO.PAS                                        *}
{*   Autor:               Krzysztof Sobusiak                             *}
{*************************************************************************}


program Skok;

const MAXPOLE  = 10000;  { max nr pola na wejsciu }

      MARGINES = 100; { margines bezpieczenstwa }

      MAXWIEZ  = MAXPOLE+2*MARGINES+1;   { liczba pol planszy }

var Plansza : array [-MARGINES..MAXPOLE+MARGINES] of LongInt;

    lewo,prawo : Integer;  { numery pol planszy, na ktorych stoja pionki: }

                           { skrajnie lewy i prawy                        }

    Wieze : array [1..MAXWIEZ] of Integer;  { kolejka wiez wysokosci >=3 }

                                            { - tablica cykliczna        }

    w1,w2 : Word;   { poczatek i koniec kolejki }



procedure WstawWieze(pole : Integer);

{ wstawia do kolejki dane pole }

begin

  Wieze[w2]:=pole;

  Inc(w2);

  if w2>MAXWIEZ

    then w2:=1

end;



procedure WczytajDane;

var F        : Text;

    n,i,pole : Integer;

    pionki   : LongInt;

begin

  Assign(F,'sko.in');

  Reset(F);

  Readln(F,n);

  FillChar(Plansza,SizeOf(Plansza),0);

  w1:=1; w2:=1;

  lewo:=0;

  for i:=1 to n do

    begin

      Readln(F,pole,pionki);

      Plansza[pole]:=pionki;

      if pionki>=3

        then WstawWieze(pole)

    end;

  prawo:=pole;            { prawy skrajny pionek }

  Close(F)

end;



procedure PostawPionki(pole : Integer;

                       ile  : LongInt);

{ stawia "ile" pionkow na polu o numerze "pole",     }

{ uaktualniajac odpowiednio indeksy "lewo" i "prawo" }

begin

  Inc(Plansza[pole],ile);

  if lewo>pole

    then lewo:=pole;

  if prawo<pole

    then prawo:=pole

end;



function NowaWieza(pole : Integer;

                   ile  : LongInt) : Boolean;

{ odpowiada, czy po postawieniu "ile" pionkow na polu "pole" }

{ powstanie nowa wieza wysokosci >=3                         }

begin

  NowaWieza:=(Plansza[pole]<3) and (Plansza[pole]+ile>=3)

end;



procedure Rozrzuc;

{ rozrzuca wieze pionkow do wysokosci co najwyzej 2 }

var ile    : LongInt;

    pole   : Integer;

begin

  while w1<>w2 do   { dopoki jest co rozrzucac }

    begin

      pole:=Wieze[w1];

      ile:=Plansza[pole] div 3;  { podziel wieze }

      if NowaWieza(pole-2,ile)   { jesli z lewej strony utworzy sie nowa      }

        then WstawWieze(pole-2); { wieza wysokosci>=3, to wstaw ja do kolejki }

      PostawPionki(pole-2,ile);  { postaw czesc pionkow z lewej strony }

      if NowaWieza(pole+2,ile)   { jesli z prawej strony utworzy sie nowa     }

        then WstawWieze(pole+2); { wieza wysokosci>=3, to wstaw ja do kolejki }

      PostawPionki(pole+2,ile);  { postaw czesc pionkow z prawej strony }

      Dec(Plansza[pole],3*ile);  { i zdejmij ze srodka }

      if Plansza[pole]>=3        { jesli pozostalo >=3 pionkow, }

        then WstawWieze(pole);   { to wstaw je do kolejki       }

      Inc(w1);                   { wez nastepna wieze }

      if w1>MAXWIEZ

        then w1:=1

    end

end;



procedure Przeskakuj(pole : Integer);

{ wykonuje sekwencje bic pojedynczym pionkiem zaczynajac od pola "pole"; }

{ zaklada, ze na prawo znajduja sie izolowane pojedyncze pionki          }

begin

  Plansza[pole]:=0;

  while Plansza[pole+1]>0 do  { poki jest co bic }

    begin

      Plansza[pole+1]:=0;     { wykonaj bicie }

      Inc(pole,2)

    end;

  PostawPionki(pole,1)

end;



procedure Zbijaj;

{ zamienia konfiguracje wiez wysokosci <= 2 w konfiguracje koncowa }

var pole : Integer;

begin

  pole:=prawo;   { zacznij od skrajnie prawego pola }

  while pole>=lewo do   { skoncz na skrajnie lewym }

    { niezmiennik petli:

    { po prawej stronie pola o numerze "pole" znajduja sie izolowane pionki, }

    { na polu i po jego lewej stronie stoja wieze wysokosci <=3              }

    begin

      if Plansza[pole]>0  { jesli pole niepuste }

        then begin

               if Plansza[pole+1]=1  { jesli jeden pionek na polu z prawej }

                 then begin

                        Dec(Plansza[pole]);

                        Plansza[pole+1]:=0;       { wykonaj bicie        }

                        PostawPionki(pole+2,1);

                        Przeskakuj(pole+2)        { ... i przeskakiwanie }

                      end;

               if Plansza[pole]=2     { jesli na polu leza 2 pionki }

                 then begin

                        Plansza[pole]:=0;   { rozstaw je odpowiednio }

                        PostawPionki(pole-2,1); { skok w lewo, potem w prawo }

                        PostawPionki(pole+1,1); { - w skrocie                }

                        Przeskakuj(pole+1)  { i zrob przeskakiwanie  }

                      end

                 else if Plansza[pole]=3   { jesli na polu leza 3 pionki }

                        then begin

                               PostawPionki(pole-2,1);

                               Plansza[pole]:=1;       { podobnie jak wyzej }

                               PostawPionki(pole+1,1);

                               Przeskakuj(pole+Plansza[pole+2])

                             end

                        { jesli na polu lezy 1 pionek, to juz jest OK }

             end;

      Dec(pole)   { wez nastepne pole }

    end

end;



procedure ZapiszWynik;

{ zapisuje konfiguracje koncowa do pliku }

var F    : Text;

    pole : Integer;

begin

  Assign(F,'sko.out');

  Rewrite(F);

  for pole:=lewo to prawo do

    if Plansza[pole]=1

      then Write(F,pole,' ');

  Close(F)

end;



begin

  WczytajDane;

  Rozrzuc;

  Zbijaj;

  ZapiszWynik

end.

