{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: TANIE PODROZE                                  *}
{*   Plik:                TAN.PAS                                        *}
{*   Autor:               Jacek Chrzaszcz                                *}
{*************************************************************************}


program tanie_podroze;
{programowanie dynamiczne}

const
  MaxHotel    = 1000; {maksymalna liczba hoteli}
  MaxDziennie = 800;  {M - max. liczba kilometrow dziennie}

type
  Hotel = record
            odleglosc : integer;
            cena      : integer;
            tan, dro  : record  {koszt dla wersji tanszej i drozszej}
                          nastepnik : integer;  {najlepszy nastepnik}
                          pieniadze : longint;
                          noclegi   : integer;
                        end;
          end;

var
  Hotele  : array [0..MaxHotel+2] of Hotel; {Hotele + "straznicy"}
  ileH    : integer;     {H - liczba hoteli}
  Dlugosc : integer;     {D - dlugosc trasy}


procedure Wczytaj_Dane;
var
  i : integer;
  f : text;
begin
  assign(f,'tan.in');
  reset(f);
  readln(f, Dlugosc, ileH);
  for i:=1 to ileH do
    readln(f,Hotele[i].odleglosc, Hotele[i].cena);
  close(f);
end; { Wczytaj_Dane }


function Policz_Noclegi : boolean;
 { Liczy dla kazdego hotelu tansza i drozsza wersje rozplanowania
   noclegow, potrzebnych aby dojechac do konca trasy}
 { Jesli obliczenia koncza sie poprawnie zwracana jest wartosc TRUE}
var
  i,j       : integer;
  MinTan, MinDro : integer;
begin
  Policz_Noclegi:=false;
  with Hotele[0] do begin {poczatek trasy - "pierwszy obowiazkowy hotel"}
    odleglosc:=0;
    cena:=0;
  end;
  with Hotele[ileH+1] do begin {koniec trasy - "ostatni obowiazkowy hotel"}
    odleglosc:=Dlugosc;
    cena:=0;
    tan.nastepnik:=-1;
    tan.pieniadze:=0;
    tan.noclegi:=0;
    dro.nastepnik:=-1;
    dro.pieniadze:=0;
    dro.noclegi:=0;
  end;
  with Hotele[ileH+2] do begin
                {straznik - "hotel za daleko", a przy okazji el. najwiekszy}
    odleglosc:=Dlugosc+MaxDziennie+100;
    cena:=0;
    tan.nastepnik:=-1;
    tan.pieniadze:=MaxLongInt;   {(+infty, +infty)}
    tan.noclegi:=MaxInt;
    dro.nastepnik:=-1;
    dro.pieniadze:=MaxLongInt;   {(+infty, +infty)}
    dro.noclegi:=MaxInt;
  end;

  for i:=ileH downto 0 do begin
    {nocujemy w hotelu i oraz szukamy, jaki nocleg nastepny bylby najlepszy
     zeby jak najtaniej/najszybciej dojechac do konca trasy}

    MinTan:=ileH+2;   {(+infty, +infty)}
    MinDro:=ileH+2;

    j:=i+1;
    while Hotele[j].odleglosc-Hotele[i].odleglosc <= MaxDziennie do begin

      {przegladamy wszystkie hotele, ktore moglyby byc nastepnymi
       noclegami po i;
       nie wyjdziemy poza zakres, bo broni nam tego straznik
       i<=ileH, czyli j<=ileH+2 }

      if (Hotele[j].tan.pieniadze<Hotele[MinTan].tan.pieniadze)
         or
           (Hotele[j].tan.pieniadze=Hotele[MinTan].tan.pieniadze)
           and
           (Hotele[j].tan.noclegi<Hotele[MinTan].tan.noclegi)
      then
        MinTan:=j;     {szukanie nastepnika o minimalnym koszcie}


      if (Hotele[j].dro.noclegi<Hotele[MinDro].dro.noclegi)
         or
           (Hotele[j].dro.noclegi=Hotele[MinDro].dro.noclegi)
           and
           (Hotele[j].dro.pieniadze<Hotele[MinDro].dro.pieniadze)
      then
        MinDro:=j;

      j:=j+1;
    end;

    if (MinDro=ileH+2) or (MinTan=ileH+2) then
      exit; {nie da sie znalezc nastepnego hotelu - zwroc blad}


    {obliczamy koszt dojazdu do konca trasy z pierwszym noclegiem w i}
    with Hotele[i].tan do begin
      nastepnik:=MinTan;
      pieniadze:=Hotele[MinTan].tan.pieniadze+Hotele[i].cena;
      noclegi:=Hotele[MinTan].tan.noclegi+1;
    end;

    with Hotele[i].dro do begin
      nastepnik:=MinDro;
      pieniadze:=Hotele[MinDro].dro.pieniadze+Hotele[i].cena;
      noclegi:=Hotele[MinDro].dro.noclegi+1;
    end;

  end; {for i:=ileH downto 0}

  Policz_Noclegi:=true; {wszystko w porzadku, jest policzone}
end; { Policz_Noclegi }


procedure Wypisz_Drogi;
var
  f : text;
  i : integer;
begin
  assign(f,'tan.out');
  rewrite(f);
  i:=Hotele[0].tan.nastepnik;
  while (Hotele[i].tan.nastepnik<>-1) do begin
    write(f,Hotele[i].odleglosc,' ');
    i:=Hotele[i].tan.nastepnik;
  end;
  writeln(f);

  i:=Hotele[0].dro.nastepnik;
  while (Hotele[i].dro.nastepnik<>-1) do begin
    write(f,Hotele[i].odleglosc,' ');
    i:=Hotele[i].dro.nastepnik;
  end;
  writeln(f);
  close(f);
end; { Wypisz_Drogi }


begin { Program glowny }
  Wczytaj_Dane;

  if not Policz_Noclegi then begin
    writeln('Blad: nie da sie zaplanowac noclegow...');
    halt;
  end;

  Wypisz_Drogi;
end. { Program glowny }
