{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: TROJKATY JEDNOBARWNE                           *}
{*   Plik:                TRO.PAS                                        *}
{*   Autor:               Marcin Engel                                   *}
{*************************************************************************}


const

  maxn = 1000;

var

  d : array [1..maxn] of longint;  { d[i] = liczba czerwonych odcinkow
                                     opuszczajacych i-ty punkt }

  n, m : longint;                   { Liczby, odpowiednie, punktow i
                                      odcinkow czerwonych. }



procedure otworz;

{ Wczytuje dane }

var

  i, p, k : longint;

  we : text; { Plik z danymi }

begin

  { Otworz pliki }

  assign (we, 'TRO.IN');

  reset (we);

  { Wczytaj liczby, odpowiednio, punktow i czerwonych odcinkow.}

  readln (we, n, m);

  { Inicjacja tablicy d. }

  for i := 1 to n do d [i] := 0;

  { Wczytanie czerwonych odcinkow i zliczenie dla kazdego punktu
    czerwonych odcinkow o jednym koncu w tym punkcie. }

  for i := 1 to m do begin

    readln (we, p, k);

    inc (d[p]);

    inc (d[k]);

  end;

  close (we);

end;



function ile : longint;

{ Zwraca liczbe trojkatow jednobarwnych. }

var

  k, roznobarwne : longint;

begin

  { Policz liczbe trojkatow roznobarwnych - zliczajac w kazdym wierzcholku

    liczbe par odcinkow roznych kolorow, kazdy trojkat zostanie zliczony

    dwa razy. }

  roznobarwne := 0;

  for k := 1 to n do

    inc (roznobarwne, d [k] * (n - 1 - d [k]));

  roznobarwne := roznobarwne div 2;

  { Trojkaty jednobarwne to wszystkie trojkaty minus roznobarwne. }

  ile := (n * (n - 1) * (n - 2)) div 6 - roznobarwne

end;



Procedure zapisz;

{ Zapisuje wynik }

var

  wy : text; { Plik wynikowy }

begin

  assign (wy, 'TRO.OUT');

  rewrite (wy);

  writeln (wy, ile);

  close (wy);

end;


begin

  otworz;

  zapisz

end.