{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: TROJKATY                                       *}
{*   Plik:                TRO1.PAS                                       *}
{*   Autor:               Marcin Engel                                   *}
{*************************************************************************}


const

  maxn = 1000;

  bit = 32;

  zbiormax = maxn div bit;

type

  zbior = array [1..zbiormax] of longint;

var

  odc : array [1..maxn] of ^ zbior; {Odcinki. 
                                     Kolejne bity odc[i] wskazuja na kolory
                                     kolejnych odcinkow opuszczajacych punkt i.}

  kod : array [1..bit] of longint;

  n : integer;


procedure Init;

{ Wczytaj i inicjuj struktre danych. }

var

  we : text;

  x, y : integer;

  i, j, m : longint;

begin

  { Tablica masek kolejnych bitow. }

  for i := 1 to bit do

    kod [i] := longint(1) shl (i-1);

  { Plik wejsciowy. }

  assign (we, 'TRO.IN');

  reset (we);

  readln (we, n);

  readln (we, m);

  { Tablica krawedzi }

  for i := 1 to n do begin

    new (odc [i]);

    for j := 1 to zbiormax do

      odc [i]^[j] := 0;

  end;

  { Kolejne odcinki. }

  for i := 1 to m do begin

    readln (we, x, y);

    odc [x]^[(y-1) div bit + 1] := odc[x]^[(y-1) div bit + 1] or

                                     kod [(y-1) mod bit + 1];

  end;

  close (we)

end;



procedure wypisz;

var

  wy : text;

  nz : string;

  x, y, z : integer;

  roznobarwne : longint;

  k : boolean;

begin

  { Otwarcie pliku }

  assign (wy, 'TRO.OUT');

  rewrite (wy);

  { Trojkaty }

  roznobarwne := 0;

  for x := 1 to n do

    for y := x+1 to n do begin

      k := odc[x]^[(y-1) div bit + 1] and kod [(y-1) mod bit + 1] = 0;

      for z := y+1 to n do begin

        if  ((odc[x]^[(z-1) div bit + 1] and kod [(z-1) mod bit + 1] = 0) = k)

        and ((odc[y]^[(z-1) div bit + 1] and kod [(z-1) mod bit + 1] = 0) = k)

        then

          inc (roznobarwne)

      end

    end;

  writeln (wy, roznobarwne);

  close (wy);

end;



begin

  init;

  wypisz

end.