{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: WIARYGODNOSC SWIADKOW                          *}
{*   Plik:                WIA.PAS                                        *}
{*   Autor:               Grzegorz Jakacki                               *}
{*************************************************************************}


{$M 65000,0,655360}

Program WiarygodnoscSwiadkow;

const	MaxSwiadkow = 3000;
type    wsk = ^sasiad;
	sasiad = record
          nr : integer;
          nast : wsk
        end;
        swiadek = record
          tak : wsk;
          nie : wsk;
          popierany : boolean;
          niewiarygodny : boolean
        end;
var	swiadkowie : array[1..MaxSwiadkow] of swiadek;
	zgadzaSieZ : array[1..MaxSwiadkow] of integer;
        zIluSieZgadza : integer;
	iluSwiadkow : integer;
        ileZeznan : integer;

Procedure WczytajZeznania;

  Procedure dopisz(var gdzie : wsk; co : integer);
  var	nast : wsk;
  begin
    nast := gdzie;
    new(gdzie);
    gdzie^.nast := nast;
    gdzie^.nr := co
  end;

var	i, kto, oKim : integer;
	we : text;
Begin
  assign(we, 'wia.in');
  reset(we);
  readln(we, iluSwiadkow);
  readln(we, ileZeznan);
  for i := 1 to iluSwiadkow do
    with swiadkowie[i] do begin
      tak := nil;
      nie := nil;
      popierany := false;
      niewiarygodny := false
    end;
  for i := 1 to ileZeznan do begin
    readln(we, kto, oKim);
    if oKim > 0 then dopisz(swiadkowie[kto].tak, oKim)
    else dopisz(swiadkowie[kto].nie, -oKim);
  end;
  close(we)
End;

Procedure Wyznacz;

  Procedure Odwiedz(s : integer);
  var	odwiedzany : wsk;
  Begin
    swiadkowie[s].popierany := true;
    zIluSieZgadza := zIluSieZgadza + 1;
    zgadzaSieZ[zIluSieZgadza] := s;

    odwiedzany := swiadkowie[s].tak;
    while (odwiedzany <> nil) and not swiadkowie[s].niewiarygodny do begin
      if not swiadkowie[odwiedzany^.nr].popierany then Odwiedz(odwiedzany^.nr);
      swiadkowie[s].niewiarygodny := swiadkowie[odwiedzany^.nr].niewiarygodny;
      odwiedzany := odwiedzany^.nast
    end
  End;

  Procedure AnulujPoparcie;
  var	i : integer;
  Begin
    for i := 1 to zIluSieZgadza do
      swiadkowie[zgadzaSieZ[i]].popierany := false;

    zIluSieZgadza := 0
  End;

  Procedure TestujNaSprzecznosc(s : integer);
  var	oskarzany : wsk;
  	i : integer;
  Begin
    for i := 1 to zIluSieZgadza do begin
      oskarzany := swiadkowie[zgadzaSieZ[i]].nie;
      while (oskarzany <> nil) and (not swiadkowie[s].niewiarygodny) do begin
        swiadkowie[s].niewiarygodny := swiadkowie[oskarzany^.nr].popierany;
        oskarzany := oskarzany^.nast
      end
    end
  End;

var	i : integer;

Begin
  zIluSieZgadza := 0;
  For i := 1 to iluSwiadkow do begin
    (* if not PopieraNiewiarygodnych(i) then TestujNaSprzecznosc(i); *)
    Odwiedz(i);
    if not swiadkowie[i].niewiarygodny then TestujNaSprzecznosc(i);
    AnulujPoparcie
  end
End;

Procedure WypiszWynik;
var	nikt : boolean;
	i : integer;
        wy : text;
Begin
  assign(wy, 'wia.out');
  rewrite(wy);
  nikt := true;
  For i := 1 to iluSwiadkow do
    if swiadkowie[i].niewiarygodny then begin
      writeln(wy, i);
      nikt := false
    end;
  if nikt then writeln(wy, 'NIKT');
  close(wy);
End;

Begin
  WczytajZeznania;
  Wyznacz;
  WypiszWynik
End.
