
{*************************************************************************}
{*                                                                       *}
{*                   IV Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwiazanie zadania: BRAMKI XOR                                     *}
{*   Plik:                XOR.PAS                                        *}
{*   Autor:               Marek Pawlicki                                 *}
{*************************************************************************}



{$M 40000, 0, 655360}

program BramkiXor;


const

  MaxLiczbaBramek = 3000;

  MaxLiczbaWejsc  =  100;


type

  (* Stan binarny. *)

  TStan = 0..1;

  (* Element oznaczajacy bramke lub wejscie sieci. *)

  TElement = record

               (* Numery bramek podlaczonych do wejsc. Nieistotne dla

                  wejscia sieci. *)

               Wejscie1, Wejscie2 : Integer;

               (* Stan na wyjsciu bramki lub stan wejscia sieci. *)

               Wyjscie : TStan;

               (* Oznacza, czy wartosc "Wyjscie" jest wyznaczona. *)

               WyjscieObliczone : Boolean

             end;

  (* Siec zlozona z bramek i wejsc. *)

  TSiec = array [-MaxLiczbaWejsc..MaxLiczbaBramek] of TElement;

  (* Wielomian. *)

  TWielomian = array [1..MaxLiczbaWejsc] of TStan;


var

  (* Pliki wejsciowy i wyjsciowy. *)

  PlWe, PlWy : Text;

  (* Siec. *)

  S : TSiec;

  LiczbaWejsc : Integer;

  LiczbaBramek : Integer;

  WyjscieSieci : Integer;

  (* Wielomian dla sieci S. *)

  WielomianSieci : TWielomian;


  procedure WczytajSiec;

  (* Wczytuje z otwartego pliku wejsciowego opis sieci. *)

  var

    i : Integer;

  begin

    Readln (PlWe, LiczbaWejsc, LiczbaBramek, WyjscieSieci);

    for i := 1 to LiczbaBramek do

      Readln (PlWe, S[i].Wejscie1, S[i].Wejscie2)

  end;


  procedure ObliczBramke (nr : Integer);

  (* Oblicza wartosc na wyjsciu bramki o numerze "nr". *)

  var

    We1, We2 : Integer;

  begin

    We1 := S[nr].Wejscie1; We2 := S[nr].Wejscie2;

    (* Oblicz wartosci wyjsciowe bramek podlaczonych do wejsc,

       jezeli nie sa jeszcze wyznaczone. *)

    if not S[We1].WyjscieObliczone then ObliczBramke (We1);

    if not S[We2].WyjscieObliczone then ObliczBramke (We2);

    (* Oblicz wartosc na wyjsciu. *)

    S[nr].Wyjscie := (S[We1].Wyjscie + S[We2].Wyjscie) mod 2;

    (* Zaznacz, ze wartosc na wyjsciu wyznaczona. *)

    S[nr].WyjscieObliczone := true

  end;


  procedure ObliczWielomianSieci;

  (* Oblicza wielomian wczytanej sieci. *)

  var

    i, j : Integer;

  begin

    (* Wyzeruj wejscia sieci. *)

    for i := 1 to LiczbaWejsc do begin

      S[-i].Wyjscie := 0; S[-i].WyjscieObliczone := true

    end;

    for i := 1 to LiczbaWejsc do begin

      (* Oblicz i-ty wspolczynnik wielomianu. *)

      (* Wstepnie wartosc dla zadnej bramki nie jest wyznaczona. *)

      for j := 1 to LiczbaBramek do

        S[j].WyjscieObliczone := false;

      (* Jedynka na i-tym wejsciu. *)

      S[-i].Wyjscie := 1;

      if i > 1 then S[-i+1].Wyjscie := 0;

      (* Oblicz wartosc na wyjsciu sieci ... *)

      ObliczBramke (WyjscieSieci);

      (* ... ktora jest szukanym wspolczynnikiem. *)

      WielomianSieci[i] := S[WyjscieSieci].Wyjscie

    end

  end;


  procedure ObliczWynik;

  (* Wczytuje wartosci graniczne z pliku wejsciowego i oblicza wynik. *)

  var

    Dane, Koniec : TWielomian;

    LiczbaJedynek : Longint;


    function RowneDane (var D1, D2 : TWielomian) : Boolean;

    (* Zwraca "true" wtw, gdy wielomiany D1 i D2 sa rowne. *)

    var

      i : Integer;

      r : Boolean;

    begin

      r := true; i := 1;

      while r and (i <= LiczbaWejsc) do begin

        r := D1[i] = D2[i];

        Inc (i)

      end;

      RowneDane := r

    end;


    procedure CzytajZestawDanych (var D : TWielomian);

    (* Wczytuje na "D" z pliku wejsciowego stan wejsc sieci. *)

    var

      i : Integer;

      c : Char;

    begin

      for i := 1 to LiczbaWejsc do begin

        Read (PlWe, c);

        D[i] := Ord (c) - Ord ('0')

      end;

      Readln (PlWe)

    end;


    function Wynik (var D : TWielomian) : TStan;

    (* Oblicza wartosc na wyjsciu sieci dla danych "D". *)

    var

      i : Integer;

      s : Integer;

    begin

      s := 0;

      for i := 1 to LiczbaWejsc do

        s := s + WielomianSieci[i] * D[i];

      Wynik := s mod 2

    end;


    procedure KolejnyZestaw (var D : TWielomian);

    (* Oblicza dane nastepne dla danych "D". *)

    var

      i : Integer;

    begin

      i := LiczbaWejsc;

      while D[i] = 1 do begin

        D[i] := 0; Dec (i)

      end;

      D[i] := 1

    end;


  begin

    LiczbaJedynek := 0;

    (* Wczytaj wartosci graniczne. *)

    CzytajZestawDanych (Dane);

    CzytajZestawDanych (Koniec);

    (* Zlicz jedynki dla danych okreslonych przez wartosci graniczne. *)

    LiczbaJedynek := LiczbaJedynek + Wynik (Dane);

    while not RowneDane (Dane, Koniec) do begin

      KolejnyZestaw (Dane);

      LiczbaJedynek := LiczbaJedynek + Wynik (Dane)

    end;

    (* Zapisz wynik w pliku wyjsciowym. *)

    Writeln (PlWy, LiczbaJedynek)

  end;


begin

  (* Otwarcie plikow. *)

  Assign (PlWe, 'xor.in');

  Reset (PlWe);

  Assign (PlWy, 'xor.out');

  Rewrite (PlWy);

  (* Wykonanie zadania. *)

  WczytajSiec;

  ObliczWielomianSieci;

  ObliczWynik;

  (* Zamkniecie plikow. *)

  Close (PlWe);

  Close (PlWy)

end.
