{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: BITMAPA                                        *}
{*   Plik:                BIT.PAS                                        *}
{*   Autor:               Marcin Mucha                                   *}
{*************************************************************************}



const
   INFTY = 55555;
   X_MIN = 1;
   X_MAX = 182;
   Y_MIN = 1;
   Y_MAX = 182;
type
   pelem = ^telem;
   telem = record
      x, y : byte;
      next : pelem
   end;
   tqueue = record
      head, last : pelem
   end;

   prow = ^trow;
   trow = array[1..182] of word;
var
   queue : tqueue;
   bitmap : array[1..182] of prow;
   n, m : byte;
   fin, fout : text;

procedure init_queue( var queue : tqueue);
begin
   queue.head := nil;
   queue.last := nil;
end;

function queue_empty( queue : tqueue) : boolean;
begin
   queue_empty := ( queue.head = nil)
end;

function remove_first( var queue : tqueue) : pelem;
begin
   remove_first := queue.head;
   queue.head := queue.head^.next;
   if queue.head = nil then
      queue.last := nil
end;

procedure add( var queue : tqueue; elem : pelem);
begin
   elem^.next := nil;
   if queue.head = nil then
      queue.head := elem
   else
      queue.last^.next := elem;
   queue.last := elem
end;

procedure adjust( x, y : byte; dist : word);
var
   p : pelem;
begin
   if ( x >= X_MIN) and ( x <= n) and ( y >= Y_MIN) and ( y <= m) then
      if bitmap[x]^[y] > dist then
         begin
            bitmap[x]^[y] := dist;
            new( p);
            p^.x := x; p^.y := y;
            add( queue, p)
         end
end;

procedure read_data;
var
   i, j : byte;
   s : string;
begin
   init_queue( queue);

   assign( fin, 'bit.in');
   reset( fin);
   readln( fin, n, m);
   for i := 1 to n do
      begin
         new( bitmap[i]);
         for j := 1 to m do
            bitmap[i]^[j] := INFTY
      end;
   for i := 1 to n do
      begin
         readln( fin, s);
         for j := 1 to m do
            if s[j] = '1' then
               adjust( i, j, 0)
      end;
   close( fin)
end;

procedure bfs;
var
   p : pelem;
   x, y : byte;
   dist : word;
begin
   while not queue_empty( queue) do
      begin
         p := remove_first( queue);
         x := p^.x; y := p^.y; dist := bitmap[x]^[y];
         adjust( x - 1, y, dist + 1);
         adjust( x + 1, y, dist + 1);
         adjust( x, y - 1, dist + 1);
         adjust( x, y + 1, dist + 1);
         dispose( p)
      end
end;

procedure write_results;
var
   i, j : byte;
begin
   assign( fout, 'bit.out');
   rewrite( fout);
   for i := 1 to n do
      begin
         for j := 1 to m do
            begin
               write( fout, bitmap[i]^[j]);
               if j <> m then
                  write( fout, ' ')
            end;
         dispose( bitmap[i]);
         writeln( fout)
      end;
   close( fout)
end;

begin
   read_data;
   bfs;
   write_results
end.