{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: GROTOAZI                                      *}
{*   Plik:                GRO.PAS                                        *}
{*   Autor:               Krzysztof Sobusiak                             *}
{*************************************************************************}

program Grotolazi;
const MAXN = 200;
      ID = 'GRO';
var T : array [1..MAXN,1..MAXN] of Boolean; { macierz incydencji }
    A,B : array [1..MAXN] of Boolean;
      { graf dwudzielny - zaznaczamy wierzchoki nalece do obu podzbiorw }
    n : Word; { liczba wierzchokw grafu wejciowego }
    ns : Word; { rozmiar skojarzenia }
    f : Text;

procedure WczytajDane;
{ wczytanie danych i inicjacja struktur }
var i,j,s,v : Word;
begin
  Readln(f,n);
  for i:=1 to n do
    begin
      A[i]:=False; B[i]:=False;
      for j:=1 to n do
        T[i,j]:=False
    end;
  for i:=1 to n-1 do { wczytaj graf }
    begin
      Read(f,s);
      for j:=1 to s do
        begin
          Read(f,v);
          T[i,v]:=True
        end;
      Readln(f)
    end;
  for i:=1 to n do { utwrz graf dwudzielny }
    begin
      A[i]:=T[1,i];
      B[i]:=T[i,n]
    end;
  ns:=Ord(T[1,n]) { ewentualna krawd $1->n$ bdzie nalee do skojarzenia }
end;

procedure Domknij;
{ domknicie przechodnie grafu }
var k,i,j : Word;
begin
  for k:=1 to n do
    for i:=1 to n do
      if T[i,k]
        then for j:=1 to n do
               T[i,j]:=T[i,j] or T[k,j];
  for i:=1 to n do { ustaw zwrotno }
    T[i,i]:=True
end;

var OB : array [1..MAXN] of Boolean;
       { znaczniki odwiedzenia wierzchokw ze zbioru $B$ }
    SA,SB : array [1..MAXN] of Word;
       { krawdzie skojarzenia dla wierzchokw ze zbiorw $A$ i $B$ }
       { np. SA[i]=0 oznacza, ze $i$ ze zbioru $A$ jest wolny }

function Powieksz(i : Word) : Boolean;
{ szukanie rekurencyjnie (DFS) scieki rozszerzajcej }
{ z danego wierzchoka nalecego do zbioru $A$ grafu dwudzielnego, }
{ w przypadku powodzenia powikszenie skojarzenie wzdu znalezionej scieki }
var j : Word;
begin
  { pojedynczy krok - przejcie po krawdzi wolnej, }
  { a nastpnie po krawdzi skojarzenia }
  for j:=i to n do { przegldaj ssiadw }
    if T[i,j] and    { musi istnie krawd $i->j$ }
       B[j] and      { $j$ musi nalee do zbioru $B$ }
       not OB[j] and { $j$ nie moe by odwiedzony }
       (SA[i]<>j)    { krawd $i->j$ nie moe nalee do skojarzenia }
      then begin
             OB[j]:=True; { zaznacz, e $j$ jest odwiedzony }
             if (SB[j]=0) or { jeli $j$ jest wolny, to koniec cieki }
                Powieksz(SB[j]) { wpp. przejd po krawdzi skojarzenia }
                                { do wierzchoka w zbiorze $A$ i szukaj dalej}
               then begin { cieka znaleziona }
                      SA[i]:=j; { uaktualnij skojarzenie }
                      SB[j]:=i;
                      Powieksz:=True;
                      Exit
                    end
           end;
  Powieksz:=False { nie udao si znale cieki }
end;

procedure Skojarz;
{ szukanie skojarzenia o maksymalnej licznoci }
var i,j : Word;
    pow : Boolean;
begin
  for i:=1 to n do
    begin
      SA[i]:=0; SB[i]:=0 { pocztkowo skojarzenie jest puste }
    end;
  for j:=1 to n do
    OB[j]:=False;
  repeat
    pow:=False;
    for i:=1 to n do
      if A[i] and (SA[i]=0) { z wolnego wierzchoka ze zbioru $A$ }
        then begin          { szukaj cieki rozszerzajcej }
               if Powieksz(i)
                 then begin
                        pow:=True;
                        Inc(ns);
                        for j:=1 to n do
                          OB[j]:=False
                      end
             end
  until not pow { jeli nie istnieje cieka rozszerzajaca, to koniec }
end;

begin
  Assign(f,ID+'.in');
  Reset(f);
  WczytajDane;
  Close(f);
  Domknij;
  Skojarz;
  Assign(f,ID+'.out');
  Rewrite(f);
  Writeln(f,ns);
  Close(f)
end.
