{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: LODOWISKO                                      *}
{*   Plik:                LOD.PAS                                        *}
{*   Autor:               Adam Borowski                                  *}
{*************************************************************************}

type
  PA10000word=^TA10000word;    {potrzebujemy wicej pamici ni 64KB}
  TA10000word=array[0..10001] of word;
  TA15000word=array[0..15000] of word;
  koniec=(mniejszy,wiekszy);
const  {rozmiary poziomw drzewa}
  pdrzewa:array[0..14] of
          word=(0,1,2,4,9,19,39,78,156,312,625,1250,2500,5000,10000);
var
  i,j,q,
  n,m,                   {liczba naronikw, liczba krawdzi}
  r,s:word;
  sx,sy,tx,ty:integer;   {pooenie startu/mety}
  x,y:array[0..10000] of integer;{wsprzdne naronikw; 0 to punkt startowy}
  next:array[0..10000] of word;  {tablica nastpnikw wierzchokw}
  prev:PA10000word;              {tablica poprzednikw wierzchokw}
  t:array[koniec] of PA10000word;{gdzie wyldujemy idc z danego odcinka
                                  w obu kierunkach bdcych
                                  jego "przedueniami"}

  l,nast:array[koniec] of ^TA15000word; {tablice pomocnicze dla sortowania}
  iln:array[koniec] of word;                                  {kubekowego}

  x1,y1,x2,y2:integer;
  ziemia:PA10000word;                   {najniszy poziom drzewa}
  drzewo:array[0..14] of PA10000word;   {i samo drzewo}
  k:koniec;
  q0,q1,q2:PA10000word; {kolejki}
  wq0,wq1,wq2:word;     {koce kolejek}
  bylo:PA10000word;     {czy znalelimy ju ten wierzchoek?}

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure Wal(k:koniec;w:word;a:integer); {wrzucenie elementu do kubeka}
begin
  if l[k]^[a]=0
    then begin
           l[k]^[a]:=w;
           nast[k]^[w]:=0
         end
    else begin
           inc(iln[k]);
           l[k]^[iln[k]]:=l[k]^[a];
           l[k]^[a]:=w;
           nast[k]^[w]:=iln[k]
         end
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure Add(x:integer;w:word); {wstaw warto w do drzewa pod indeksem x}
var
  p:byte;
begin
  ziemia^[x]:=w;
  for p:=13 downto 0
    do begin
         x:=x div 2;
         inc(drzewo[p]^[x])
       end
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure Del(x:integer;w:word); {usu z drzewa warto w pod indeksem x}
var
  p:byte;
begin
  ziemia^[x]:=0;
  for p:=13 downto 0
    do begin
         x:=x div 2;
         dec(drzewo[p]^[x])
       end
end;


(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)


function Find(x:integer;dir:boolean):word; {znajd warto na lewo/prawo od x}
const
  lp:array[boolean] of integer=(-1,1);
var
  p:shortint;
begin
  p:=14;
  while (p<>-1) and ((odd(x)=dir) or (drzewo[p]^[x+lp[dir]]=0))
    do begin
         dec(p);
         x:=x div 2
       end;
  if p>=0
    then begin
           inc(x,lp[dir]);
           for p:=p+1 to 14
             do if drzewo[p]^[2*x+ord(not dir)]=0
                  then x:=2*x+ord(dir)
                  else x:=2*x+ord(not dir);
           Find:=drzewo[14]^[x]
         end
    else Find:=0
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

function lewo(x1,y1,x2,y2,x,y:integer):boolean;{czy punkt ley na lewo od }
begin                                  {prostej zawierajcej odcinek}
  lewo:=longint(y1-y)*(x2-x1)<longint(y1-y2)*(x-x1)
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

function IsRight(v:word;xi,yi:integer):boolean;{czy punkt lecy na odcinku v}
var                                          {jest prawostronnym naronikiem?}
  w:word;
begin
  w:=next[v];
  IsRight:=((x[v]=xi) and (y[v]=yi) and
           not lewo(x[prev^[v]],y[prev^[v]],x[v],y[v],x[w],y[w]))
      or ((x[w]=xi) and (y[w]=yi) and
          not lewo(x[v],y[v],x[w],y[w],x[next[w]],y[next[w]]))
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure AddQueue(q:byte;v:word); {dodanie elementu do kolejki numer q}
begin
  if bylo^[v]<=r+q
    then exit
    else bylo^[v]:=r+q;
  if q=1
    then begin
           inc(wq1);
           q1^[wq1]:=v
         end
    else begin
           inc(wq2);
           q2^[wq2]:=v
         end
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure Wynik(r:word);  {wypisanie wyniku}
begin
  write(r);
  close(output);
  halt
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure RouteX(dir:boolean;s,v:word); {idziemy poziomo}
begin
  if (y[s]=ty)          {dotrzemy do mety?}
    then begin
           x1:=x[s];
           x2:=x[next[s]];
           if (x1>x2)=dir
             then x1:=x2;
           if dir
             then if (tx>x1) and ((v=0) or (tx<=x[v]))
                    then Wynik(r+1)
                    else
             else if (tx<x1) and ((v=0) or (tx>=x[v]))
                    then Wynik(r+1)
         end;
  if v=0
    then exit;
  AddQueue(1,v);        {idziemy w jedn stron...}
  if y[v]=y[s]
    then AddQueue(1,prev^[v]) {...i w drug}
    else if y[next[v]]=y[s]
           then AddQueue(1,next[v]);
  if (x[s]<x[next[s]])=dir {przypadek }
    then AddQueue(2,next[s])
    else AddQueue(2,prev^[s])
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

procedure RouteY(dir:boolean;s,v:word); {idziemy pionowo}
begin
  if (x[s]=tx)          {dotrzemy do mety?}
    then begin
           y1:=y[s];
           y2:=y[next[s]];
           if (y1>y2)=dir
             then y1:=y2;
           if dir
             then if (ty>y1) and ((v=0) or (ty<=y[v]))
                    then Wynik(r+1)
                    else
             else if (ty<y1) and ((v=0) or (ty>=y[v]))
                    then Wynik(r+1)
         end;
  if v=0
    then exit;
  AddQueue(1,v);        {idziemy w jedn stron...}
  if x[v]=x[s]
    then AddQueue(1,prev^[v]) {...i w drug}
    else if x[next[v]]=x[s]
           then AddQueue(1,next[v]);
  if (y[s]>y[next[s]])=dir {przypadek }
    then AddQueue(2,prev^[s])
    else AddQueue(2,next[s])
end;

(*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*&*)

begin
  assign(input,'lod.in');
  reset(input);
  readln(sx,sy);
  readln(tx,ty);
  readln(s);
  n:=0;
  for i:=1 to s
    do begin
         readln(r);
         readln(x1,y1);  {wierzchoki nieparzyste maj oznacza pocztek}
         readln(x2,y2);  {krawdzi pionowych, parzyste - poziomych}
         if x1<>x2
           then begin
                  x[n+2]:=x1; y[n+2]:=y1; {jeli trzeba, obracamy}
                  x[n+3]:=x2; y[n+3]:=y2; {wierzchoki ciany}
                  for j:=4 to r
                    do readln(x[n+j],y[n+j]);
                  readln(x[n+1],y[n+1])
                end
           else begin
                  x[n+1]:=x1; y[n+1]:=y1;
                  x[n+2]:=x2; y[n+2]:=y2;
                  for j:=3 to r
                    do readln(x[n+j],y[n+j])
                end;
         for j:=n+1 to n+r-1
           do next[j]:=j+1; {ustawiamy wskaniki na nastpne wierzchoki...}
         next[n+r]:=n+1;
         inc(n,r)
       end;
  close(input);

  x[0]:=sx;
  y[0]:=sy;
  next[0]:=0;
  m:=n div 2;
  new(prev);
  for i:=0 to n
    do prev^[next[i]]:=i;  {... i na poprzednie}

  for i:=0 to 14
    do GetMem(drzewo[i],(pdrzewa[i]+2)*SizeOf(word)); {0..n+wartownik}
  ziemia:=drzewo[14];
  new(t[mniejszy]);
  new(t[wiekszy]);
  new(l[mniejszy]);
  new(l[wiekszy]);
  new(nast[mniejszy]);  {alokujemy zmienne}
  new(nast[wiekszy]);
  new(q0);
  new(q1);
  new(q2);
  wq1:=0;
  wq2:=0;
  new(bylo);
  FillChar(bylo^,SizeOf(bylo^),255); {tablica odlegoci:=INF}
  r:=0;

{ odcinki pionowe }
  FillChar(l[mniejszy]^,SizeOf(TA10000word),0);
  FillChar(l[wiekszy]^,SizeOf(TA10000word),0);
  iln[mniejszy]:=10000;
  iln[wiekszy]:=10000;
  for i:=0 to 14
    do FillChar(drzewo[i]^,(pdrzewa[i]+2)*SizeOf(word),0);
  for i:=1 to n
    do if odd(i)
         then if y[i]<y[next[i]]  {sortujemy pocztki i koce kubekowo}
                then begin
                       Wal(mniejszy,i,y[i]);
                       Wal(wiekszy,i,y[next[i]])
                     end
                else begin
                       Wal(mniejszy,i,y[next[i]]);
                       Wal(wiekszy,i,y[i])
                     end;

  for i:=0 to 10000 {miota}
    do begin
         j:=i;
         while l[mniejszy]^[j]<>0 {s jakie pocztki?}
           do begin
                q:=l[mniejszy]^[j];
                Add(x[q],q);
                j:=nast[mniejszy]^[q];
                if j=0
                  then break
              end;
         if i=sy                  {punkt startowy}
           then begin
                  j:=Find(sx+1,false); { wcznie z aktualn lini}
                  if (j<>0) and IsRight(j,sx,sy)
                    then j:=Find(x[j],false);
                  if (j<>0) and (y[j]<y[next[j]])
                    then j:=Find(x[j],false);
                  RouteX(false,0,j);
                  j:=Find(sx-1,true);
                  if (j<>0) and IsRight(j,sx,sy)
                    then j:=Find(x[j],true);
                  if (j<>0) and (y[j]>y[next[j]])
                    then j:=Find(x[j],true);
                  RouteX(true,0,j)
                end;
         for k:=mniejszy to wiekszy
           do begin
                j:=i;
                while l[k]^[j]<>0
                  do begin
                       q:=l[k]^[j];
                       if y[q]=i
                         then
                           t[wiekszy]^[prev^[q]]:=Find(x[q],y[q]>y[next[q]])
                         else
                           t[mniejszy]^[next[q]]:=Find(x[q],y[q]>y[next[q]]);
                       j:=nast[k]^[q];
                       if j=0
                         then break
                     end;
              end;
         j:=i;
         while l[wiekszy]^[j]<>0  {s jakie koce?}
           do begin
                q:=l[wiekszy]^[j];
                Del(x[q],q);
                j:=nast[wiekszy]^[q];
                if j=0
                  then break
              end
       end;

{ odcinki poziome }
  FillChar(l[mniejszy]^,SizeOf(TA10000word),0);
  FillChar(l[wiekszy]^,SizeOf(TA10000word),0);
  iln[mniejszy]:=10000;
  iln[wiekszy]:=10000;
  for i:=0 to 14
    do FillChar(drzewo[i]^,(pdrzewa[i]+2)*SizeOf(word),0);
  for i:=1 to n
    do if not odd(i)
         then if x[i]<x[next[i]]  {sortujemy pocztki i koce kubekowo}
                then begin
                       Wal(mniejszy,i,x[i]);
                       Wal(wiekszy,i,x[next[i]])
                     end
                else begin
                       Wal(mniejszy,i,x[next[i]]);
                       Wal(wiekszy,i,x[i])
                     end;

  for i:=0 to 10000 {miota}
    do begin
         j:=i;
         while l[mniejszy]^[j]<>0 {s jakie pocztki?}
           do begin
                q:=l[mniejszy]^[j];
                Add(y[q],q);
                j:=nast[mniejszy]^[q];
                if j=0
                  then break
              end;
         if i=sx                  {punkt startowy}
           then begin
                  j:=Find(sy+1,false); {wcznie z aktualn lini}
                  if (j<>0) and IsRight(j,sx,sy)
                    then j:=Find(y[j],false);
                  if (j<>0) and (x[j]>x[next[j]])
                    then j:=Find(y[j],false);
                  RouteY(false,0,j);
                  j:=Find(sy-1,true);
                  if (j<>0) and IsRight(j,sx,sy)
                    then j:=Find(y[j],true);
                  if (j<>0) and (x[j]<x[next[j]])
                    then j:=Find(y[j],true);
                  RouteY(true,0,j)
                end;
         for k:=mniejszy to wiekszy
           do begin
                j:=i;
                while l[k]^[j]<>0
                  do begin
                       q:=l[k]^[j];
                       if x[q]=i
                         then
                           t[wiekszy]^[prev^[q]]:=Find(y[q],x[q]<x[next[q]])
                         else
                           t[mniejszy]^[next[q]]:=Find(y[q],x[q]<x[next[q]]);
                       j:=nast[k]^[q];
                       if j=0
                         then break
                     end;
              end;
         j:=i;
         while l[wiekszy]^[j]<>0  {s jakie koce?}
           do begin
                q:=l[wiekszy]^[j];
                Del(y[q],q);
                j:=nast[wiekszy]^[q];
                if j=0
                  then break
              end
       end;

  for i:=1 to n                      {rogi "wewntrzne"}
    do if lewo(x[prev^[i]],y[prev^[i]],x[i],y[i],x[next[i]],y[next[i]])
         then begin
                t[wiekszy]^[prev^[i]]:=i;
                t[mniejszy]^[i]:=prev^[i]
              end;
  assign(output,'lod.out');
  rewrite(output);
  wq2:=0;
  repeat
    inc(r);
    ziemia:=q0; {zamiana kolejek}
    q0:=q1;
    q1:=q2;
    q2:=ziemia;
    wq0:=wq1;
    wq1:=wq2;
    wq2:=0;
    for i:=1 to wq0
      do begin
           s:=q0^[i];
           if odd(s)       {odcinek pionowy czy poziomy?}
             then begin
                    RouteY(y[s]>y[next[s]],s,t[mniejszy]^[s]);
                    RouteY(y[s]<y[next[s]],s,t[wiekszy]^[s])
                  end
             else begin
                    RouteX(x[s]>x[next[s]],s,t[mniejszy]^[s]);
                    RouteX(x[s]<x[next[s]],s,t[wiekszy]^[s])
                  end
         end
  until (wq1=0) and (wq2=0);
  write('NIE');
  close(output)
end.