{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: LUNATYK                                        *}
{*   Plik:                LUN.PAS                                        *}
{*   Autor:               Adam Borowski                                  *}
{*************************************************************************}

type
  liczba10=string;
  liczba3=array[1..120] of shortint; {cyfry s oznaczane przez liczby -1,0,1}
  wektor=record x,y:shortint end;

var
  k:byte;

procedure kafel(var x,y,wynik:liczba3); {odlego kafla (x,y) od (1,1)}
var
  dx,dy:wektor; {orientacja aktualnego kwadratu}
  i:byte;
  b:byte;
  procedure SetD(xx,xy,yx,yy:shortint); {unikamy zmiennych pomocniczych}
  begin
    dx.x:=xx;
    dx.y:=xy;
    dy.x:=yx;
    dy.y:=yy
  end;
const
  blok:array[-1..1,-1..1] of byte=((0,7,8),(1,6,5),(2,3,4));
begin
  dx.x:=1; dx.y:=0;
  dy.x:=0; dy.y:=1;
  for i:=k downto 1
    do begin
         b:=blok[dx.x*x[i]+dy.x*y[i],dx.y*x[i]+dy.y*y[i]];
         case b of
       {a} 0,1:SetD(dx.y,dx.x,dy.y,dy.x);
       {b} 6,7:SetD(dx.y,-dx.x,-dy.y,dy.x);
       {c}   5:SetD(-dx.x,-dx.y,-dy.x,-dy.y)
          end;
         wynik[2*i-1]:=b mod 3-1;
         wynik[2*i  ]:=b div 3-1
       end
end;


{ tu sie zaczynaj funkcje arytmetyczne na duych liczbach }

function sum(a,b:liczba10):liczba10;
var
  i,d,c:byte;
  t:liczba10;
begin
  if length(b)>length(a)
    then begin
           t:=a;
           a:=b;
           b:=t
         end;
  c:=0;
  d:=length(a)-length(b);
  for i:=length(b) downto 1
    do begin
         inc(c,ord(a[d+i])+ord(b[i])-2*48);
         a[d+i]:=char(c mod 10+48);
         c:=c div 10
       end;
  for i:=d downto 1
    do begin
         if c=0
           then break;
         inc(a[i],c);
         if a[i]>'9'
           then begin
                  dec(a[i],10);
                  c:=1
                end
           else c:=0
       end;
  if c=0
    then sum:=a
    else sum:='1'+a
end;

function razy3(x:liczba10):liczba10;
var
  c,i:byte;
begin
  c:=0;
  for i:=length(x) downto 1
    do begin
         inc(c,3*(ord(x[i])-48));
         x[i]:=char(c mod 10+48);
         c:=c div 10
       end;
  case c of
    0:razy3:=x;
    1:razy3:='1'+x;
    2:razy3:='2'+x
   end
end;

function dziel3(var x:liczba10):byte; {reszta jako wynik funkcji}
var
  i,c:byte;
begin
  c:=0;
  for i:=1 to length(x)
    do begin
         c:=c*10+ord(x[i])-48;
         x[i]:=char(c div 3+48);
         c:=c mod 3
       end;
  if (x<>'0') and (x[1]='0')
    then delete(x,1,1);
  dziel3:=c
end;

function minus(a,b:string):string;
var
  i,d:byte;
  c:shortint;
begin
  c:=0;
  d:=length(a)-length(b);
  for i:=length(b) downto 1
    do begin
         inc(c,ord(a[d+i])-ord(b[i]));
         if c>=0
           then begin
                  a[d+i]:=char(c+48);
                  c:=0
                end
           else begin
                  a[d+i]:=char(c+58);
                  c:=-1
                end
       end;
  if c<>0
    then  for i:=d downto 1
            do if a[i]='0'
                 then a[i]:='9'
                 else begin
                        dec(a[i]);
                        break
                      end;
  while (a<>'0') and (a[1]='0')
    do delete(a,1,1);
  minus:=a
end;

{ ... i konwersja na system trjkowy }

function num3to10(const x:liczba3;len:byte):liczba10;
const
  cyfra:array[-1..1] of char='012';
var
  y:liczba10;
  i:byte;
begin
  y:='0';
  for i:=len downto 1
    do y:=sum(razy3(y),cyfra[x[i]]);
  num3to10:=y
end;

procedure num10to3(x:liczba10;var y:liczba3;len:byte);
var
  i:byte;
begin
  for i:=1 to len
    do y[i]:=shortint(dziel3(x))-1
end;

{koniec procedur arytmetycznych}



var
  lin:string;
  x1,y1,x2,y2:liczba10;
  a,b,c,d,w1,w2:liczba3;
begin
  assign(input,'lun.in');
  reset(input);
  readln(k);
  readln(lin);                  {parsowanie wejcia}
  x1:=copy(lin,1,pos(' ',lin)-1);
  y1:=copy(lin,pos(' ',lin)+1,length(lin));
  readln(lin);
  x2:=copy(lin,1,pos(' ',lin)-1);
  y2:=copy(lin,pos(' ',lin)+1,length(lin));
  close(input);
  num10to3(minus(x1,'1'),a,k);{odjcie od wsprzdnych 1, co gwarantuje e  }
  num10to3(minus(y1,'1'),b,k);{nale do przedziai [0..3^k - 1]             }
  num10to3(minus(x2,'1'),c,k);
  num10to3(minus(y2,'1'),d,k);
  kafel(a,b,w1);
  kafel(c,d,w2);

  assign(output,'lun.out');
  rewrite(output);
  write(minus(num3to10(w2,2*k),num3to10(w1,2*k))); {wynik=w2-w1}
  close(output)
end.