{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: MAGAZYNIER                                     *}
{*   Plik:                MAG.PAS                                        *}
{*   Autor:               Marcin Stefaniak                               *}
{*************************************************************************}

{$A+,B-,D+,E+,F-,G-,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V+,X+}
{$M 16384,0,655360}
program Magazynier;

const MAXN=100;
      MAXM=100;
      MAXD=(2+MAXN)*(2+MAXM);

type tt=array[0..MAXD-1] of integer; pt=^tt;            {wierzchoki}
     tt1=array[0..MAXD-1] of word; pt1=^tt1;            {wierzchoki}
     te=array[0..2*MAXD-1] of integer; pe=^te;          {krawdzie }
     te1=array[0..2*MAXD-1] of word; pe1=^te1;          {krawdzie }

var n,m,d:integer;
    poz_m,poz_p,poz_k:integer;

var low,nr:tt; {-1 ciana; 0 nieodwiedzony; >0 numer w drzewie w gb}


var marked:pt;
    stack:pt1;
    is:integer;

function is_way(poz_m, poz,poz_p : integer):boolean;
{czy magazynier przejdzie z poz_m do poz, poz_p - pozycja paczki}
{przeszukiwanie w gb}
{funkcja korzysta z marked, stack}

var v:integer;

begin
 if nr[poz] <> -1 then begin
  fillchar(marked^,d*sizeof(integer),0);
  marked^[poz_p] := 1;
  is := -1; inc(is); stack^[is] := poz_m; marked^[poz_m] := 1;
  while is>=0 do begin
    v:=stack^[is];
    if v=poz then begin is_way:=true; exit; end;
    if marked^[v+1]=0 then begin
      marked^[v+1]:=1;
      if nr[v+1]<>-1 then begin inc(is); stack^[is]:=v+1; end;
    end else if marked^[v-1]=0 then begin
      marked^[v-1]:=1;
      if nr[v-1]<>-1 then begin inc(is); stack^[is]:=v-1; end;
    end else if marked^[v+m+2]=0 then begin
      marked^[v+m+2]:=1;
      if nr[v+m+2]<>-1 then begin inc(is); stack^[is]:=v+m+2; end;
    end else if marked^[v-m-2]=0 then begin
      marked^[v-m-2]:=1;
      if nr[v-m-2]<>-1 then begin inc(is); stack^[is]:=v-m-2; end;
    end else begin
      stack^[is]:=0;
      dec(is);
    end;
  end;
 end;
 is_way := false;
end;

var B : pe1;      {numery skadowych dwuspjnych}
    stack2 : pe1; {stos krawdzi}
    is2 : integer;
    prev: pt;

procedure BC_components;
{wyznacza skadowe 2spjne grafu magazynu, wynik w tablicy B}
{korzysta z prev    - poprzedni wierzchoek na stosie przegldania w gb
            stack2  - stos krawdzi
            nr      - numery wierzchokw przy przejciu w gb
            low     - tablica low
            marked  - ktry nastpnik tego wierzchoka rozpatrujemy
 jawna rekurencja odpada z przyczyn technicznych (za may stos)
 jest ona symulowana za pomoc goto i stos w tablicy poprzednikw prev
}
label _start, _while_begin, _end, _exit, _return, _recursion;

var id,l:integer;
    vv,v,u,w,dir,e0,e : integer;

begin
  id:=0; l:=0;
  for vv:=0 to d-1 do if (nr[vv]=0) then begin {kolejna spjna skladowa}

    prev^[vv] := -1; v:=vv;
    is2 := 0;

    {rekurencja implementowana przez goto}

    _start:
      inc(l); nr[v] := l; low[v]:=l; marked^[v] := 0;

      _while_begin:
        {w := kolejny nastpnik v}
        if (marked^[v]=0) then
          if (nr[v-m-2]<>-1) then w:=v-m-2 else inc(marked^[v]);
        if (marked^[v]=1) then
          if (nr[v+1]<>-1) then w:=v+1 else inc(marked^[v]);
        if (marked^[v]=2) then
          if (nr[v+m+2]<>-1) then w:=v+m+2 else inc(marked^[v]);
        if (marked^[v]=3) then
          if (nr[v-1]<>-1) then w:=v-1 else inc(marked^[v]);
        if (marked^[v]=4) then {nie ma ju jak w gb} goto _exit;
        if nr[w]=0 then {nieodwiedzony jeszcze} begin
          { PUSH(Stack2, krawd(v,w)); }
          if v<w then stack2^[is2] := v else stack2^[is2] := w;
          if abs(v-w)=1 then {pozioma} inc(stack2^[is2], d);
          inc(is2);
          { Search_b(w); }
        _recursion:
          prev^[w] := v; v:=w; goto _start;
        _return:
          if low[w]>=nr[v] then begin {wykryto 2sp. skadow z kraw. v-w}
            inc(id);
            { e0 := krawd(v,w); }
            if v<w then e0 := v else e0 := w;
            if abs(v-w)=1 then {pozioma} inc(e0, d);
            repeat
              dec(is2); e := stack2^[is2];
              B^[e] := id;
            until e=e0;
          end else if low[w]<low[v] then low[v] := low[w];
        end else {ju odwiedzony}
          if (nr[w]<nr[v])and(w<>prev^[v]) then begin
            {w jest przodkiem v w drzewie BSF rnym od poprzednika v}
            { PUSH(Stac2, krawd(v,w)); }
            if v<w then stack2^[is2] := v else stack2^[is2] := w;
            if abs(v-w)=1 then {pozioma} inc(stack2^[is2], d);
            inc(is2);
            if nr[w] < low[v] then low[v] := nr[w];
          end;
        {kolejny nastpnik}
        inc(marked^[v]);
      goto _while_begin;

    _exit:
      w:=v; v:= prev^[v]; if v<>-1 then goto _return;
    _end:

  end;
end;

procedure write_output(turn:integer);
var f:text;

begin
  assign(f,'mag.out'); rewrite(f);
    write(f,turn);
  close(f);
  halt;
end;

procedure write_no;
var f:text;

begin
  assign(f,'mag.out'); rewrite(f);
    write(f,'NIE');
  close(f);
  halt;
end;



const MAXQueue = 15000; {to ograniczenie moe by mniejsze}

type tqueue = array [0..MAXQueue-1] of word; pqueue = ^tqueue;

var qu1,qu2,aux : pqueue;
    iqu1, iqu2 : integer;


procedure BSF;

var visited:pt;

procedure insert(poz_p, dir:integer);
{dir =zwrot paczka->magazynier}
var poz,dd:integer;
begin

  case dir of
    0 : begin poz := poz_p+m+2; dd:=1; end;
    1 : begin poz := poz_p-1;   dd:=2; end;
    2 : begin poz := poz_p-m-2; dd:=4; end;
    3 : begin poz := poz_p+1;   dd:=8; end;
  end;
  if (nr[poz] <> -1)and(visited^[poz] and dd=0) then begin
    inc(visited^[poz], dd);
    qu2^[iqu2] := word(poz) + word(dir)*word(d);
    inc(iqu2);
  end;
end;

var i,turn:longint;
    e,e0,e1,mag,pcz:longint;

begin
  new(visited);
  fillchar(visited^, d*sizeof(integer), 0);
  new(qu1); new(qu2);
  fillchar(qu1^, sizeof(qu1^), 0);
  fillchar(qu2^, sizeof(qu2^), 0);

  iqu1 := 0; iqu2 := 0;
  if is_way(poz_m, poz_p-m-2, poz_p) then insert(poz_p, 0);
  if is_way(poz_m, poz_p+1  , poz_p) then insert(poz_p, 1);
  if is_way(poz_m, poz_p+m+2, poz_p) then insert(poz_p, 2);
  if is_way(poz_m, poz_p-1  , poz_p) then insert(poz_p, 3);

  turn := 0;

  while iqu2>0 do begin
    aux := qu2; qu2:=qu1; qu1:=aux; iqu1:=iqu2; iqu2:=0;

    inc(turn);
    for i:=0 to iqu1-1 do begin
      e := qu1^[i];
      pcz := e mod d;
      if pcz=poz_k then write_output(turn);
      case e div d of
        0: mag:=pcz-m-2;
        1: mag:=pcz+1;
        2: mag:=pcz+m+2;
        3: mag:=pcz-1;
      end;
      {e0 := krawd(mag,pcz)}
      if mag<pcz then e0 := mag else e0 := pcz;
      if abs(mag-pcz)=1 then {pozioma} inc(e0, d);
      if (B^[e0] = B^[pcz-m-2]) then insert(pcz, 0);
      if (B^[e0] = B^[pcz + d]) then insert(pcz, 1);
      if (B^[e0] = B^[pcz    ]) then insert(pcz, 2);
      if (B^[e0] = B^[pcz-1+d]) then insert(pcz, 3);

    end;
  end;

  write_no
end;

procedure read_input;
var f:text;
    c:char;
    i,j:integer;

begin
  assign(f,'mag.in'); reset(f);
  readln(f,n,m);
  d:=(n+2)*(m+2);
  for i:=0 to n+1 do begin nr[i*(m+2)]:=-1; nr[i*(m+2)+m+1]:=-1 end;
  for j:=0 to m+1 do begin nr[j]:=-1;     nr[(n+1)*(m+2)+j]:=-1 end;
  for i:=1 to n do begin
    for j:=1 to m do begin read(f,c);
      case c of
      'S' : nr[j+i*(m+2)] := -1;
      'w' : nr[j+i*(m+2)] := 0;
      'M' : poz_m := j+i*(m+2);
      'P' : poz_p := j+i*(m+2);
      'K' : poz_k := j+i*(m+2)
      end
    end;
    readln(f)
  end;
  nr[poz_m] := 0; nr[poz_k] := 0; nr[poz_p] := 0;
  close(f)
end;



Begin
  read_input;

  new(B); new(stack2); new(prev); new(marked);

  BC_components;

  new(stack);

  BSF
End.