{***************************************************************************}
{*                                                                         *}
{*                   VI Olimpiada Informatyczna                            *}
{*                                                                         *}
{*   Rozwizanie zadania: MAPA                                             *}
{*   Plik:                MAP.PAS                                          *}
{*   Autor:               Marek Pawlicki                                   *}
{***************************************************************************}

{$R-,B-}
program Map;
(***************************************************************************)
(* Metoda: Rozwizanie dynamiczne w koszcie O(N^2)                         *)
(***************************************************************************)
const
  (* Maksymalna liczba gmin *)
  MaxLiczbaGmin = 2999;
  (* Maksymalna liczba kolorw *)
  MaxLiczbaKolorow = 10;
  (* Nazwa pliku wejciowego *)
  NazwaPlikuWe = 'map.in';
  (* Nazwa pliku wyjciowego *)
  NazwaPlikuWy = 'map.out';

var
  (* Liczba gmin w zestawie danych *)
  LiczbaGmin : Integer;
  (* Liczba kolorw w zestawie danych *)
  LiczbaKolorow : Integer;
  (* Liczby mieszkacw gmin w zestawie danych *)
  LiczbaMieszkancow : array [1..MaxLiczbaGmin] of Longint;
  (* Znaleziony optymalny podzia *)
  OptymalnyPodzial : array [1..MaxLiczbaKolorow] of Longint;
  (* Znaleziona warto minimalna wyraenia *)
  MinWartosc : Longint;


  procedure WczytajDane;
  (* Wczytanie danych z pliku wejciowego NazwaPlikuWe *)
  var
    (* Plik wejsciowy *)
    f : Text;
    (* Licznik petli *)
    i : Integer;
  begin
    Assign (f, NazwaPlikuWe);
    Reset (f);
    Readln (f, LiczbaGmin);
    Readln (f, LiczbaKolorow);
    (* Wczytanie liczebnoci gmin *)
    for i := 1 to LiczbaGmin do
      Readln (f, LiczbaMieszkancow [i]);
    Close (f)
  end;


  procedure RozwiazZadanie;
  (* Rozwizanie zadania metod dynamiczn w koszcie O(LiczbaGmin^2) *)
  const
    (* Nieskoczono *)
    Ns = MaxLongint;
  type
    TabInd = array [1..MaxLiczbaKolorow, 1..MaxLiczbaGmin] of Integer;
    TabWart = array [1..MaxLiczbaGmin] of Longint;
    PTabWart = ^TabWart;
  var
    (* Nast^[k,g] = indeks pocztku nastpnego bloku w minimalnym podziale
       odcinka g..LiczbaGmin na k blokw *)
    Nast : ^TabInd;
    (* MinPop^[g] = warto minimalna dla podziau odcinka g..LiczbaGmin na
       k-1 blokw.
       MinAkt^[g] = j. w. dla k blokw. *)
    MinAkt, MinPop : PTabWart;

    procedure SortujLiczebnosciGmin;
    (* Sortuje liczebnoci gmin w tablicy LiczbaMieszkancow metoda
       pozycyjn w koszcie O(LiczbaGmin) *)
    const
      (* Maksymalna warto pozycji *)
      M = 255;
    type
      Cast = array [1..4] of Byte;
    var
      (* Tablica pomocnicza *)
      T : array [1..MaxLiczbaGmin] of Longint;
      (* Liczba wystpie wartoci 0..M *)
      C : array [0..M] of Integer;
      (* Numer Fazy *)
      Faza : Integer;
      (* Liczniki ptli *)
      i, j : Integer;
    begin
      for Faza := 1 to 4 do begin
        for j := 0 to M do C[j] := 0;
        for i := 1 to LiczbaGmin do
          Inc (C [Cast(LiczbaMieszkancow[i])[Faza]]);
        for j := 1 to M do
          Inc (C[j], C[j-1]);
        for i := LiczbaGmin downto 1 do begin
          T [C [Cast(LiczbaMieszkancow[i])[Faza]]] := LiczbaMieszkancow[i];
          Dec (C [Cast(LiczbaMieszkancow[i])[Faza]])
        end;
        for i := 1 to LiczbaGmin do
          LiczbaMieszkancow [i] := T [i]
      end
    end;

    procedure RozwiazDynamicznie;
    (* Rozwizanie zadania metod dynamiczn *)
    var
      (* W = warto wyraenia dla bloku gmin zew..g-1 *)
      W : Longint;
      (* Liczniki ptli *)
      zew, g, k : Integer;
      (* Warto minimalna i indeks *)
      wmin : Longint;
      ind : Integer;
      (* Mediana w poprzednim kroku *)
      popmed : Longint;
      (* Pomocnicza *)
      Temp : PTabWart;
    begin
      (* Wyliczenie wartoci dla k=1 *)
      MinPop^[LiczbaGmin] := 0;
      popmed := LiczbaMieszkancow [LiczbaGmin];
      for g := LiczbaGmin - 1 downto 1 do begin
        MinPop^[g] := MinPop^[g+1] + popmed - LiczbaMieszkancow [g];
        popmed := LiczbaMieszkancow [(g+LiczbaGmin) div 2]
      end;
      (* Wyliczenie wartoci dla LiczbaKolorow *)
      for k := 2 to LiczbaKolorow do begin
        (* Wyliczenie wartoci dla podziau na k blokw (tablica MinAkt) na
           podstawie wartoci dla podziau na k-1 blokw (tablica MinPop) *)
        for zew := LiczbaGmin-k+1 downto 1 do begin
          (* Wyliczenie wartoci dla odcinka zew..LiczbaGmin *)
          W := 0;
          wmin := Ns;
          for g := zew + 1 to LiczbaGmin-k+2 do begin
            if W + MinPop^[g] < wmin then begin
              wmin := W + MinPop^[g]; ind := g
            end;
            Inc (W, LiczbaMieszkancow[g] - LiczbaMieszkancow[(zew+g) div 2])
          end;
          MinAkt^[zew] := wmin;
          Nast^[k, zew] := ind
        end;
        (* Przepisz MinAkt na MinPop *)
        Temp := MinPop; MinPop := MinAkt; MinAkt := Temp
      end
    end;

    procedure OdczytajRozwiazanie;
    (* Odczytuje rozwizanie z tablic MinPop^ oraz Nast^ *)
    var
      (* Pomocnicze *)
      k, g : Integer;
    begin
      (* Minimalna warto wyraenia *)
      MinWartosc := MinPop^[1]
    end;

  begin (* RozwiazZadanie *)
    New (MinPop); New (MinAkt);
    New (Nast);
    SortujLiczebnosciGmin;
    RozwiazDynamicznie;
    OdczytajRozwiazanie;
    Dispose (Nast);
    Dispose (MinAkt); Dispose (MinPop)
  end;


  procedure WypiszRozwiazanie;
  (* Wypisuje rozwizanie do pliku wyjciowego NazwaPlikuWy *)
  var
    Nic : Longint;
    (* Plik wyjciowy *)
    f : Text;
    (* Licznik ptli *)
    k : Integer;
  begin
    Assign (f, NazwaPlikuWy);
    Rewrite (f);
    (* Warto minimalna wyraenia *)
    Writeln (f, MinWartosc);
    Close (f)
  end;


begin
  WczytajDane;
  RozwiazZadanie;
  WypiszRozwiazanie
end.
