{
	Generator tablic do wzorcowego rozwizania zadania
	''Monocyfrowe reprezentacje'', VI Olimpiada Informatyczna
	Autor programu: Radosaw Szklarczyk,
                        r.szklarczyk@students.mimuw.edu.pl
}

{
   Stae
}

const MAX_KUBELEK = 6000; { Warto MAX_KUBELEK ustaliem
                            eksperymentalnie: cyfra 9 ma najwicej,
                            5191, monocyfrowych reprezentacji
                            w zakresie od 1 do 999999 }

      ost_kubelek_z_szuf : array [0..9] of integer
      = (0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
      { implementacja szufladek zwizanych
      z liczba wystpien cyfry k w wyraeniu }

      MAX_REP = 3210;
              { dla kadej cyfry istnieje co najwyzej 3210
                reprezentacji (dokadnie tyle dla k = 7) }

      MAX_ARRAY = 65000; { wielko najwikszej tablicy }

{
   Struktury uywane podczas rozwizania
}
type
   tliczba_byla = array [0..32767] of byte;
var
   liczba_byla: array [0..3] of ^tliczba_byla;
                 { bitowa tablica, zaznacza wystpienie kadej z liczb.
                 Tablica jest rozmiaru 100000 bitw, bo najwiksza liczba
                 z uyciem ktrej mona wykona operacj o wyniku <= 32000
                 liczba to milion-1
				(999999 / 99) < 32000
                 W tablicy przechowywane s tylko wartoci dodatnie }



   wolny_kubelek : integer; { ostatni wolny kubeek }


   kubelki : array [0..MAX_KUBELEK] of longint; { tablica kubekw z liczbami
                                              bdcymi wynikami wyraze }

   nast_kubelek : array [0..MAX_KUBELEK] of integer;
                   { wskaniki na nastpny wolny kubeek w danej szufladzie }

   liczby_rep : array [1..MAX_REP] of integer;
                  { lista liczb, ktre maj reprezentacje }

   dlugosc_rep : array [1..MAX_REP] of byte;
                  { lista dugoci reprezentacji }

   ostatnia_rep : integer; { ostatnio zapisana reprezentacja }



{ nastpny kubeek z danej szuflady }
function wez_nast_kubelek(k : integer) : integer;
begin
   wez_nast_kubelek := nast_kubelek[k];
end;

{ pierwszy kubeek z szuflady sz }
function wez_pierwszy_kubelek(sz : integer) : integer;
begin
   wez_pierwszy_kubelek := nast_kubelek[sz];
end;

{ dopisz informacje, i dla danej cyfry k (aktualnie obliczanej)
  liczba l posiada reprezentacj dugosci dl }
procedure dopisz_reprezentacje(l : longint; dl: byte);
begin
   if (l <= 32000) then
   begin
      ostatnia_rep := ostatnia_rep+1;
      liczby_rep[ostatnia_rep] := l;
      dlugosc_rep[ostatnia_rep] := dl;
   end;
end;

function czy_liczba_byla(l : longint) : boolean;
var i, j, k : integer;
begin
   i := l div 262144; { 0..3 w zalenosci od tego,
                        ktr z tablic naley uy }
   j := (l div 8) and 32767; { pozycja w tablicy }
   k := l and 7; { przesunicie bitowe w bajcie }
   czy_liczba_byla := (((liczba_byla[i]^[j]) and (1 shl k)) <> 0);
end;

procedure dodaj_liczba_byla(l : longint);
var i, j, k : integer;
begin
   i := l div 262144; { 0..3 w zaleznoci od tego,
                        ktr z tablic naley uzy }
   j := (l div 8) and 32767; { pozycja w tablicy }
   k := l and 7; { przesunicie bitowe w bajcie }
   liczba_byla[i]^[j] := (liczba_byla[i]^[j]) or (1 shl k);
end;

{ wozenie wartoci wart do szuflady sz
	-- jesli tylko wart jest w zakresie i jeszcze nie wystpia }
procedure wrzuc_do_szuflady(sz : integer; wart : longint);
begin
	if (wart > 0) and (wart < 1000000) then
	begin
		if not czy_liczba_byla(wart) then
		begin
			kubelki[wolny_kubelek] := wart;
			nast_kubelek[ost_kubelek_z_szuf[sz]] := wolny_kubelek;
			ost_kubelek_z_szuf[sz] := wolny_kubelek;
                        wolny_kubelek := wolny_kubelek + 1;
			dodaj_liczba_byla(wart);
                        dopisz_reprezentacje(wart, sz);
		end
	end
end;

procedure rozwiaz(k : integer);
var wart_pocz_szufl : longint;
    sz, kub_sz1, kub_sz2, dl : integer;
    i, w1, w2, iloczyn, iloraz : longint;
begin
	wart_pocz_szufl := 0;

	{ dla kolejnych szuflad... }
        for dl := 1 to 8 do
	begin
		{ Inicjalizacja szuflady }
                wart_pocz_szufl := wart_pocz_szufl*10+k;
		wrzuc_do_szuflady(dl, wart_pocz_szufl);

                for sz := 1 to dl-1 do
		begin
			kub_sz1 := wez_pierwszy_kubelek(sz);

			{ wszystkie moliwe kombinacje wyrae z szuflad }
			while (kub_sz1 <> 0) do
			begin
				kub_sz2 := wez_pierwszy_kubelek(dl-sz);

				while (kub_sz2 <> 0) do
				begin
					w1 := kubelki[kub_sz1];
					w2 := kubelki[kub_sz2];
					{ + }
					wrzuc_do_szuflady(dl, w1+w2);
					{ - }
					wrzuc_do_szuflady(dl, w1-w2);
					{ * }
					iloczyn := w1*w2;
					{ czy wynik mnoenia jest poprawny?
                                          -- moliwosc przepenienia}
					if (w1 = iloczyn/w2) then
						wrzuc_do_szuflady(dl, iloczyn);
					{ / }
					iloraz := w1 div w2;
					{ czy iloraz jest cakowity? }
					if (w1 = iloraz*w2) then
						wrzuc_do_szuflady(dl, iloraz);

					kub_sz2 := wez_nast_kubelek(kub_sz2);
				end;
				kub_sz1 := wez_nast_kubelek(kub_sz1);
			end;
		end; { szuflady od 1 do dl-1 }

	end; { dla kolejnych szuflad... }
end;

procedure zapisz_tablice(k : integer; var fout : text);
var i, j, rep : integer;
begin
   { ostatnia_rep to ilo znalezionych reprezentacji }
   writeln(fout, 'const lista_liczb', k, ' : array [1..',
                 ostatnia_rep, '] of integer = (');

   rep := 0;
   for i := 1 to 32000 do
   begin
      if czy_liczba_byla(i) then
      begin
         write(fout, i);
         rep := rep+1;
         if rep < ostatnia_rep then write(fout, ',');
         writeln(fout);
      end;
   end;
   writeln(fout, ');');

   writeln(fout, 'const dlugosc_repr', k, ' : array [1..',
                 ostatnia_rep, '] of byte = (');

   rep := 0;
   for i := 1 to 32000 do
   begin
      if czy_liczba_byla(i) then
      begin
         for j := 1 to ostatnia_rep do
         begin
            if (liczby_rep[j] = i) then
            begin
               write(fout, dlugosc_rep[j]);
               rep := rep+1;
               if rep < ostatnia_rep then write(fout, ',');
               writeln(fout);
            end;
         end;
      end;
   end;
   writeln(fout, ');');
end;

procedure wyczysc_tablice;
var i, j : integer;
begin
   for i := 0 to 3 do
      for j := 0 to 32767 do
         liczba_byla[i]^[j] := 0;
   fillchar(kubelki, sizeof(kubelki), 0);
   fillchar(nast_kubelek, sizeof(nast_kubelek), 0);
end;

procedure zaalokuj_tablice;
var i, j : integer;
begin
   for i := 0 to 3 do begin
      getmem(liczba_byla[i], 32767);
   end;
end;

var i, k : integer;
    plik_wynikowy : text; { plik, w ktrym przechowywane
                            bd stablicowane dane }
begin
        { alokacja pamieci }
        zaalokuj_tablice;
        { plik wyjsciowy }
        assign(plik_wynikowy, 'mon.tab');
        rewrite(plik_wynikowy);
        { dla kolejnych cyfr badaj dugo reprezentacji }
	for k := 1 to 9 do
	begin
                wyczysc_tablice;
		wolny_kubelek := 9;
                ostatnia_rep := 0; { do listy reprezentacji }
		for i := 0 to 9 do ost_kubelek_z_szuf[i] := i;
		rozwiaz(k);
		zapisz_tablice(k, plik_wynikowy);
	end;
	close(plik_wynikowy);
end.