program Muszkieterowie_Symulacja;
{$A-,B-,D-,E-,X-,F-,G-,I-,L-,N-,P-,O-,Q-,R-,K-,S-,Y-,V-,W-}
{Generowanie rozwiazania za pomoca symulacji losowych.}
{Program: W. Guzicki}
uses Crt;

const
    MaxN = 100;

type
    Muszkieterowie = #101..#200;
    Lista          = String[MaxN];
    Tablica        = array [Muszkieterowie,Muszkieterowie] of Boolean;
    Zwyciezcy      = array [Muszkieterowie] of Boolean;

var
    n        : integer;
    Tabela   : Tablica;
    Przezyli : Zwyciezcy;
    Wszyscy  : Lista;
    Pierwszy : Muszkieterowie;
    Ostatni  : Muszkieterowie;

procedure ZapoczatkowanieDanych;
    var
        Plik  : Text;
        x,y   : Muszkieterowie;
        Cyfra : char;
    begin
        assign(Plik,'MUS.IN');
        reset(Plik);
        readln(Plik,n);
        Pierwszy:=#101;
        Ostatni:=chr(100+n);
        for x:=Pierwszy to Ostatni do begin
            for y:=Pierwszy to Ostatni do begin
                read(Plik,Cyfra);
                Tabela[x,y]:=(Cyfra='1')
            end; {for}
            readln(Plik)
        end; {for}
        close(Plik);
        {Na razie nikt nie przezyl.}
        for x:=Pierwszy to Ostatni do
            Przezyli[x]:=FALSE;
        {Lista wszystkich muszkieterow.}
        Wszyscy:='';
        for x:=Pierwszy to Ostatni do
            Wszyscy:=Wszyscy+x
    end; {ZapoczatkowanieDanych}

procedure Symulacja;
    var
        Numer,Nast,i : integer;
        Zywi         : Lista;
    begin
        Zywi:=Wszyscy;
        for i:=n downto 2 do begin
            Numer:=1+Random(i);
            if Numer<i then
                Nast:=Numer+1
            else
                Nast:=1;
            if Tabela[Zywi[Numer],Zywi[Nast]] then
                Delete(Zywi,Nast,1)
            else
                Delete(Zywi,Numer,1)
        end;
        Przezyli[Zywi[1]]:=TRUE
    end; {Symulacja}

procedure WypisanieWygranych;
    var
        Plik    : Text;
        Licznik : integer;
        x       : Muszkieterowie;
    begin
        assign(Plik,'MUS.OUT');
        rewrite(Plik);
        {Zliczamy tych, ktorzy moga przezyc.}
        Licznik:=0;
        for x:=Pierwszy to Ostatni do
            if Przezyli[x] then
                Licznik:=Licznik+1;
        writeln(Plik,Licznik);
        {Wypisujemy. Powracamy do numerow.}
        Licznik:=0;
        for x:=Pierwszy to Ostatni do begin
            Licznik:=Licznik+1;
            if Przezyli[x] then
                writeln(Plik,Licznik)
        end;
        close(Plik)
    end; {WypisanieWygranych}

var
    i : integer;
    t0,t1 : real;

begin {program}
    ZapoczatkowanieDanych;
    for i:=1 to 3000 do
        Symulacja;
    WypisanieWygranych
end.
