{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: MUSZKIETEROWIE                                 *}
{*   Plik:                MUS.PAS                                        *}
{*   Autor:               Marcin Mucha                                   *}
{*   Pomysodawca:        Marcin Sawicki                                 *}
{*************************************************************************}

(* Algorytm dynamiczny o zoonoci n^3.                                 *)
(* Dla kadego muszkietera obliczamy, ktrzy inni muszkieterowie mog    *)
(* stan po jego prawej stronie. Potem szukamy takich, ktrzy mog      *)
(* "stan po swojej prawej stronie".                                    *)

const
   MUSK_MAX = 100;

type
   musketeer = record
      wins_with : array[1..MUSK_MAX] of boolean;
      can_meet : array[1..MUSK_MAX] of boolean
   end;

const
   file_in_name = 'mus.in';
   file_out_name = 'mus.out';

var
   musk : array[1..MUSK_MAX] of musketeer;
   n : integer;
   winners : integer;
   file_in, file_out : text;

procedure read_data;
var
   i, j : integer;
   c : char;
begin
   assign( file_in, file_in_name);
   reset( file_in);
   readln( file_in, n);
   for i := 1 to n do
      begin
         for j := 1 to n do
            begin
               read( file_in, c);
               musk[i].wins_with[j] := ( c = '1')
            end;
         readln( file_in)
      end;
   close( file_in)
end;

procedure find_winners;

function next( i : integer) : integer;
begin
   next := ( i mod n) + 1
end;

function nth_next( i, j : integer) : integer;
begin
   nth_next := (( i + j - 1) mod n) + 1;
end;

var
   i, j : integer;
   first, second, dist : integer;
begin
   for i := 1 to n do
      for j := 1 to n do
         musk[i].can_meet[j] := false;
   for i := 1 to n do
      musk[i].can_meet[next( i)] := true;

   for dist := 2 to n do
      for first := 1 to n do
         begin
            second := nth_next( first, dist);
            i := next( first);
            while ( i <> first) and ( not musk[first].can_meet[second]) do
               begin
                  if musk[first].can_meet[i] and musk[i].can_meet[second] then
                     if musk[first].wins_with[i]
                        or musk[second].wins_with[i] then
                        musk[first].can_meet[second] := true;
                  i := next( i)
               end
         end;

   winners := 0;
   for i := 1 to n do
      if musk[i].can_meet[i] then
         inc( winners);
end;

procedure write_result;
var
   i : integer;
begin
   assign( file_out, file_out_name);
   rewrite( file_out);
   writeln( file_out, winners);
   for i := 1 to n do
      if musk[i].can_meet[i] then
         writeln( file_out, i);
   close( file_out)
end;

begin
   read_data;
   find_winners;
   write_result
end.