{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: OTARZE                                        *}
{*   Plik:                OLT.PAS                                        *}
{*   Autor:               Tomasz Wale                                   *}
{*************************************************************************}

program oltarze;
const
  maxn=1000;
  maxm=2*maxn+10;
  f_in='olt.in';
  f_out='olt.out';
type
 toltarz=record
  x,y,xx,yy : integer;
  d : byte;
 end;
 toltarze=array[1..maxn] of toltarz;
 poltarze=^toltarze;

var
  f : text;
  o : toltarze;
  a : array[1..maxn] of boolean;
  n : integer;
  v : array[0..maxm,1..2] of integer;{lista wektorw}
  vb : array[0..maxm] of shortint;
  vv : integer;
  px,py : integer;
  pv : array[1..2,1..2] of integer;
  pd : byte;

  procedure ReadData; {wczytywanie danych z olt.in}
  var
    i : integer;
    aa,bb,cc,dd:integer;
    ch:char;
  begin
    Assign(f,f_in);
    reset(f);
    readln(f,n);
    for i:=1 to n do
    begin
      read(f,aa,bb,cc,dd);
      read(f,ch);{opuszczanie pierwszej spacji}
      read(f,ch);
      readln(f);
      o[i].x:=aa;  o[i].y:=dd;
      o[i].xx:=cc; o[i].yy:=bb;
      case ch of
       'N':o[i].d:=1;
       'E':o[i].d:=2;
       'S':o[i].d:=3;
       'W':o[i].d:=4;
       else begin Writeln('BLAD W TESCIE!!! ch=',ch);readln; end;
      end;
    end;
    {mnoenie wszystkich wsp. przez 4, tak eby rodek oraz wsp
     brzegw bramy wityni miay zawsze wsp cakowite}
    for i:=1 to n do begin
      o[i].x:=o[i].x*4;
      o[i].y:=o[i].y*4;
      o[i].xx:=o[i].xx*4;
      o[i].yy:=o[i].yy*4;
    end;
    close(f);
  end;

  procedure WriteAnswer;
  var
    i,j : integer;
  begin
    Assign(f,f_out);
    rewrite(f);
    j:=0;
    for i:=1 to n do if a[i] then begin writeln(f,i); inc(j); end;
    if j=0 then Writeln(f,'BRAK');
    close(f);
  end;

  {liczy iloczyn skalarny dwch wektorw}
  function cp(x1,y1,x2,y2:integer):longint;
  begin
    cp:=longint(x2)*longint(y1)-longint(x1)*longint(y2);
  end;

  {dodanie dwch promieni ograniczajcych podany prostokt}
  procedure add_rect(x1,y1,x2,y2:integer);
  var
    tmp:integer;
    c11,c12,c21,c22 : longint;
    p1x,p1y,p2x,p2y:integer;
    r : array[1..4,1..2] of integer;
    i : integer;
  begin
    {szybkie sprawdzanie czy dodawanie tego prostokta ma sens}
    if (pd=1) and (y2<=pv[1,2]) then exit;
    if (pd=2) and (x2<=pv[1,1]) then exit;
    if (pd=3) and (y1>=pv[1,2]) then exit;
    if (pd=4) and (x1>=pv[1,1]) then exit;

    r[1,1]:=x1;r[1,2]:=y1;
    r[2,1]:=x1;r[2,2]:=y2;
    r[3,1]:=x2;r[3,2]:=y2;
    r[4,1]:=x2;r[4,2]:=y1;

    {wyznaczanie minimalnej pprostej}
    p1x:=x1;p1y:=y1;
    for i:=2 to 4 do if cp(p1x,p1y,r[i,1],r[i,2])<0 then
    begin
      p1x:=r[i,1];
      p1y:=r[i,2];
    end;

    {wyznaczanie maksymalnej pprostej}
    p2x:=x1;p2y:=y1;
    for i:=2 to 4 do if cp(p2x,p2y,r[i,1],r[i,2])>0 then
    begin
      p2x:=r[i,1];
      p2y:=r[i,2];
    end;

    {obliczanie czci wsplnej kta tworzonego przez pproste p1 p2
     oraz kta wyznaczonego przez rodek wityni i jej bram}
    c11:=cp(pv[1,1],pv[1,2],p1x,p1y);
    c12:=cp(pv[1,1],pv[1,2],p2x,p2y);
    if (c11<0) and (c12<=0) then exit; {jeli jej pole=0 to nie ma co liczy}
    c21:=cp(pv[2,1],pv[2,2],p1x,p1y);
    if (c21>=0) and (c12<0) then exit; {jw}
    c22:=cp(pv[2,1],pv[2,2],p2x,p2y);
    if (c21>=0) and (c22>0) then exit; {jw}
    if (c11<0) then begin p1x:=pv[1,1];p1y:=pv[1,2]; end;
    if (c22>0) then begin p2x:=pv[2,1];p2y:=pv[2,2]; end;

    {dodawanie pprostych p1 p2}
    inc(vv);
    v[vv,1]:=p1x;    v[vv,2]:=p1y;
    vb[vv]:=1;
    inc(vv);
    v[vv,1]:=p2x;    v[vv,2]:=p2y;
    vb[vv]:=-1;
  end;

  {insertion sort dla pprostych (optymalizacja QuickSort'u)}
  procedure isort(l,r:integer);
  var
    i,j,k:integer;
    mx,my,mb:integer;
  begin
    for i:=l to r do
    begin
      j:=i-1;
      mx:=v[i,1];my:=v[i,2];mb:=vb[i];
      while (j>=l) do
      begin
        if (longint(mx)*longint(v[j,2])-longint(v[j,1])*longint(my))<0
        then dec(j)
        else break;
      end;
      if j<(i-1) then
      begin
        for k:=i downto j+2 do
        begin
          v[k,1]:=v[k-1,1];
          v[k,2]:=v[k-1,2];
          vb[k]:=vb[k-1];
        end;
        v[j+1,1]:=mx;
        v[j+1,2]:=my;
        vb[j+1]:=mb;
      end;
    end;
  end;

  {sortowanie pprostych (quicksort)}
  procedure sort(l,r:integer);
  var
    i,j,m,tmp:integer;
    mx,my:longint;
  begin
    if (l>=r) then exit;
    if (r-l<15) then begin isort(l,r); exit; end;
    i:=l; j:=r;
    m:=(i+j) div 2;
    mx:=v[m,1];my:=v[m,2];
    repeat
      while (mx*longint(v[i,2])-longint(v[i,1])*my)>0
      do inc(i);
      while (longint(v[j,1])*my-mx*longint(v[j,2]))>0
      do dec(j);

      if (i<=j) then begin
        tmp:=v[j,1]; v[j,1]:=v[i,1]; v[i,1]:=tmp;
        tmp:=v[j,2]; v[j,2]:=v[i,2]; v[i,2]:=tmp;
        tmp:=vb[j];vb[j]:=vb[i];vb[i]:=tmp;
        inc(i);dec(j);
      end;
    until i>j;
    if l<j then sort(l,j);
    if i<r then sort(i,r);
  end;

  {sprawdzanie, czy dana witynia moe by zhabiona}
  function check(m:integer):boolean;
  var
    i,j:integer;
    c : longint;
    aa : boolean;
  begin
    {dodawanie dwch fikcyjnych pprostych przechodzcych przez
     bram}
    v[0,1]:=pv[1,1];v[0,2]:=pv[1,2];vb[0]:=0;
    v[m+1,1]:=pv[2,1];v[m+1,2]:=pv[2,2];vb[m+1]:=0;

    j:=0;

    aa:=false;
    for i:=0 to m do
    begin
      c := cp(v[i,1],v[i,2],v[i+1,1],v[i+1,2]);
      j := j + vb[i];
      if (j=0) and (c>0) then begin
       aa:=true; break;
      end;
    end;
    check:=aa;
  end;

  procedure Solve;
  var
    i,j,k : integer;
    x,y,xx,yy : integer;
  begin
    for i:=1 to n do
    begin
      a[i]:=false;
      pd:=o[i].d;
      xx:=o[i].xx-o[i].x;
      yy:=o[i].yy-o[i].y;
      px:=o[i].x+(xx div 2);
      py:=o[i].y+(yy div 2);

      {wyznaczanie pprostych przechodzcych przez skrajne punkty bramy}
      if o[i].d=1 then begin
        pv[1,1]:=-(xx div 4); pv[1,2]:=yy div 2;
        pv[2,1]:=xx div 4; pv[2,2]:=yy div 2;
      end else if o[i].d=2 then begin
        pv[1,1]:=(xx div 2); pv[1,2]:=(yy div 4);
        pv[2,1]:=(xx div 2); pv[2,2]:=-(yy div 4);
      end else if o[i].d=3 then begin
        pv[2,1]:=-(xx div 4); pv[2,2]:=-(yy div 2);
        pv[1,1]:=(xx div 4); pv[1,2]:=-(yy div 2);
      end else begin
        pv[2,1]:=-(xx div 2); pv[2,2]:=(yy div 4);
        pv[1,1]:=-(xx div 2); pv[1,2]:=-(yy div 4);
      end;

      vv:=0;
      for j:=1 to n do if i<>j then
        add_rect(o[j].x-px,o[j].y-py,o[j].xx-px,o[j].yy-py);

      sort(1,vv);

      a[i]:=check(vv);
    end;
  end;

begin
  ReadData;
  Solve;
  WriteAnswer;
end.
