{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: PIERWOTEK ABSTRAKCYJNY                         *}
{*   Plik:                PIE.PAS                                        *}
{*   Autor:               Marcin Mucha                                   *}
{*************************************************************************}


(* Zliczanie stopni wejciowych i wyjciowych + badanie spjnoci
   za pomoc Find-Union.  *)

const
   file_in_name = 'pie.in';
   file_out_name = 'pie.out';
   V_MAX = 1000;
   NOT_USED = 65535;

type
   FU_struct = record
      rank : word;
      father : word
   end;

var
   file_in, file_out : text;
   connected : array[1..V_MAX] of FU_struct;
   v_defect : array[1..V_MAX] of integer;
   min_length : longint;

procedure make_set( i : word);
begin
   connected[i].father := i;
   connected[i].rank := 0
end;

function find_set( i : word) : word;
begin
   if i <> connected[i].father then
      connected[i].father := find_set( connected[i].father);
   find_set := connected[i].father
end;

procedure link( i, j : word);
begin
   if connected[i].rank > connected[j].rank then
      connected[j].father := i
   else
      connected[i].father := j;
   if connected[i].rank = connected[j].rank then
      inc( connected[j].rank)
end;

procedure union( i, j : word);
begin
   if find_set( i) <> find_set( j) then
      link( find_set( i), find_set( j))
end;

procedure read_data;
var
   n : longint;
   i : longint;
   l, r : word;
begin
   readln( file_in, n);
   for i := 1 to V_MAX do
      begin
         connected[i].rank := NOT_USED;
         v_defect[i] := 0
      end;
   min_length := 0;

   for i := 1 to n do
      begin
         readln( file_in, l, r);
         if connected[l].rank = NOT_USED then
            make_set( l);
         if connected[r].rank = NOT_USED then
            make_set( r);
         union( l, r);
         dec( v_defect[l]);
         inc( v_defect[r]);
         inc( min_length)
      end
end;

procedure analyze_components;
const
   NO_COMPONENT = maxlongint;
var
   i, j : word;
   comp_no : word;
   comp_defect : array[1..V_MAX] of longint;

begin
   for i := 1 to V_MAX do comp_defect[i] := NO_COMPONENT;

   for i := 1 to V_MAX do
      if ( connected[i].rank <> NOT_USED) then
         begin
            comp_no := find_set( i);
            if ( comp_defect[comp_no] = NO_COMPONENT) then
               comp_defect[comp_no] := 0;
            if v_defect[i] > 0 then
               inc( comp_defect[comp_no], v_defect[i])
         end;

   for i := 1 to V_MAX do
      if comp_defect[i] <> NO_COMPONENT then
         begin
            if comp_defect[i] = 0 then comp_defect[i] := 1;
            inc( min_length, comp_defect[i])
         end
end;

begin
   assign( file_in, file_in_name);
   reset( file_in);
   read_data;
   close( file_in);

   analyze_components;

   assign( file_out, file_out_name);
   rewrite( file_out);
   write( file_out, min_length);
   close( file_out)
end.