{***************************************************************************}
{*                                                                         *}
{*                   VI Olimpiada Informatyczna                            *}
{*                                                                         *}
{*   Rozwizanie zadania: PUSTE PROSTOPADOCIANY                           *}
{*   Plik:                PUS.PAS                                          *}
{*   Autor:               Marek Pawlicki                                   *}
{***************************************************************************}

{$R-,B-,N+,E+}
program Pus;
(***************************************************************************)
(* Metoda:  Wyznaczenie dla kadej paszczyzny ograniczajcej moliwych    *)
(*          maksymalnych prostopadocianw o jednej ze cian nalecych   *)
(*          do tej paszczyzny.                                            *)
(*          Koszt O(n^2)                                                   *)
(***************************************************************************)
const
  (* Maksymalna liczba punktw. *)
  MaxLPunktow = 5000;
  (* Maksymalna warto wsprzdnej. *)
  MaxWartWsp = 1000000;
  (* Plik wejciowy. *)
  NazwaPlikuWe = 'pus.in';
  (* Plik wyjciowy. *)
  NazwaPlikuWy = 'pus.out';
type
  (* Rodzaj wsprzdnej. *)
  TRodzajWspol = (x, y, z);
  (* Punkt w przestrzeni. *)
  TPunkt = array [TRodzajWspol] of Longint;
  (* Zbir punktw. *)
  TZbior = array [1..MaxLPunktow+1] of TPunkt;
  PZbior = ^TZbior;
var
  (* Zbir A. *)
  ZbiorA : TZbior;
  (* Liczba punktw w zbiorze A. *)
  LiczbaPunktowA : Integer;
  (* Znaleziony punkt realizujcy maksymaln objto. *)
  PunktOdp : TPunkt;


  procedure WczytajDane;
  (* Wczytuje dane z pliku wejciowego NazwaPlikuWe. *)
  var
    (* Plik wejciowy. *)
    f : Text;
    (* Licznik ptli. *)
    i : Integer;
  begin
    Assign (f, NazwaPlikuWe);
    Reset (f);
    Readln (f, LiczbaPunktowA);
    for i := 1 to LiczbaPunktowA do
      Readln (f, ZbiorA[i,x], ZbiorA[i,y], ZbiorA[i,z]);
    Close (f)
  end;


  procedure RozwiazZadanie;
  type
    TLista = array [1..MaxLPunktow+1] of Integer;
  const
    (* Oznaczenie nil. *)
    Nic = 0;
  var
    (* Maskymalna objto. *)
    maxobj : Comp;
    (* Punkt realizujcy maksymaln objto. *)
    pkt : TPunkt;
    (* Nast^[i] = indeks nastpnego punktu na licie punktw ograniczajcych
       rozmiar prostopadocianu ze wzgldu na dwie wsprzdne przy
       przechodzeniu do kolejnych punktw po trzeciej wsprzdnej.
       Nast^[i] = Nic oznacza ostatni punkt na licie. *)
    NastL : ^TLista;
    (* Indeks pierwszego punktu na w/w licie. *)
    PierwszyL : Integer;

    procedure SortujPo (wp : TRodzajWspol);
    (* Sortuje zbir A wg wartoci wsprzdnej wp. *)
    const
      (* Maksymalna warto pozycji. *)
      M = 255;
    type
      Cast = array [1..4] of Byte;
    var
      (* Tablica pomocnicza. *)
      T : PZbior;
      (* Liczba wystpie wartoci 0..M *)
      C : array [0..M] of Integer;
      (* Numer Fazy. Poniewaz wartoci < 2^24 wic wystarcz 3 fazy. *)
      Faza : Integer;
      (* Liczniki ptli. *)
      i, j : Integer;
    begin
      New (T);
      for Faza := 1 to 3 do begin
        for j := 0 to M do C[j] := 0;
        for i := 1 to LiczbaPunktowA do
          Inc (C [Cast(ZbiorA[i,wp])[Faza]]);
        for j := 1 to M do
          Inc (C[j], C[j-1]);
        for i := LiczbaPunktowA downto 1 do begin
          T^[C [Cast(ZbiorA[i,wp])[Faza]]] := ZbiorA[i];
          Dec (C [Cast(ZbiorA[i,wp])[Faza]])
        end;
        for i := 1 to LiczbaPunktowA do
          ZbiorA[i] := T^[i]
      end;
      Dispose (T)
    end;

    procedure OkreslMaxObj (wsort, wa, wb : TRodzajWspol; kol : Comp);
    (* Oblicza maksymaln objto dla prostopadocianw wyznaczonych
       przez list Nast^. Punkty zbioru A posorotwane wg wsprzdnej wsort;
       punkty listy wg wsprzdnej wa.
       kol jest wartoci wsprzdnej wsort kolejnego punktu w zbiorze A.
       Znalezione wartoci przypisuje na zmienne maxobj i pkt *)
    var
      (* Indeksy puntkw na licie. *)
      i, pop : Integer;

      procedure Proba (a, b, sort : Comp);
      (* Sprawdza, czy prostopadocian (a, b, sort) jest lepszy od
         dotychczasowego. *)
      var
        obj : Comp;
      begin
        obj := a * b * sort;
        if obj > maxobj then begin
          maxobj := obj;
          pkt [wa] := Trunc(a);
          pkt [wb] := Trunc(b);
          pkt [wsort] := Trunc(sort)
        end
      end;

    begin
      i := PierwszyL;
      if i = Nic then
        (* Pusta lista. *)
        Proba (MaxWartWsp, MaxWartWsp, kol)
      else begin
        Proba (ZbiorA[i,wa], MaxWartWsp, kol);
        pop := i; i := NastL^[i];
        while i <> Nic do begin
          Proba (ZbiorA[i,wa], ZbiorA[pop,wb], kol);
          pop := i; i := NastL^[i]
        end;
        Proba (MaxWartWsp, ZbiorA[pop,wb], kol)
      end
    end;

    procedure SprawdzPo (w, wa, wb : TRodzajWspol);
    (* Sprawdza objtoci "przechodzc" po wsprzdnej w. *)
    var
      (* Indeks kolejnego punktu wg wsprzdnej w. *)
      IndKol : Integer;
      (* Wartoci wsprzdnych wa i wb punktu IndKol. *)
      ak, bk : Longint;
      (* Indeksy punktw na licie. *)
      i, pop : Integer;
      (* Okrela, czy punkt IndKol bdzie wstawiony do listy. *)
      Tak : Boolean;
    begin
      SortujPo (w);
      PierwszyL := Nic;
      OkreslMaxObj (w, wa, wb, ZbiorA [1,w]);
      IndKol := 1;
      while IndKol <= LiczbaPunktowA do begin
        (* Okrel, czy punkt IndKol bdzie wstawiony (Tak, jeeli nie ma
           na licie punktu o obu wsprzdnych wa i wb mniejszych lub
           rwnych). *)
        Tak := true;
        i := PierwszyL;
        ak := ZbiorA[IndKol,wa]; bk := ZbiorA[IndKol,wb];
        while (i <> Nic) and Tak do begin
          Tak := not ((ZbiorA[i,wa] <= ak) and (ZbiorA[i,wb] <= bk));
          i := NastL^[i]
        end;
        if Tak then begin
          (* Wstaw wg wsprzdnej wa. *)
          i := PierwszyL; pop := Nic;
          while (i <> Nic) and (ZbiorA[i,wa] < ak) do begin
            pop := i; i := NastL^[i]
          end;
          if pop = Nic then begin
            (* Wstaw na pocztek listy. *)
            NastL^[IndKol] := PierwszyL;
            PierwszyL := IndKol
          end else begin
            (* Wstaw po elemencie pop. *)
            NastL^[IndKol] := NastL^[pop];
            NastL^[pop] := IndKol
          end;
          (* Usu z listy punkty, ktrych obie wsprzdne wa i wb s
             wiksze lub rwne od wsprzdnych punktu wstawianego. *)
          pop := IndKol; i := NastL^[IndKol];
          while i <> Nic do
            if (ZbiorA[i,wa] >= ak) and (ZbiorA[i,wb] >= bk) then begin
              (* Usu punkt i z listy. *)
              i := NastL^[i]; NastL^[pop] := i
            end else begin
              pop := i; i := NastL^[i]
            end
        end;
        Inc (IndKol);
        OkreslMaxObj (w, wa, wb, ZbiorA [IndKol,w])
      end
    end;

  begin (* RozwiazZadanie *)
    New (NastL);
    (* Dodanie fikcyjnego punktu. *)
    ZbiorA[LiczbaPunktowA+1,x] := MaxWartWsp;
    ZbiorA[LiczbaPunktowA+1,y] := MaxWartWsp;
    ZbiorA[LiczbaPunktowA+1,z] := MaxWartWsp;
    (* Znalezienie punktu. *)
    maxobj := 0;
    SprawdzPo (x, z, y);
    PunktOdp := pkt;
    Dispose (NastL)
  end;


  procedure WypiszWynik;
  var
    (* Plik wyjciowy. *)
    f : Text;
  begin
    Assign (f, NazwaPlikuWy);
    Rewrite (f);
    Writeln (f, PunktOdp[x], ' ', PunktOdp[y], ' ', PunktOdp[z]);
    Close (f)
  end;


begin
  WczytajDane;
  RozwiazZadanie;
  WypiszWynik
end.