{*************************************************************************}
{*                                                                       *}
{*                   VI Olimpiada Informatyczna                          *}
{*                                                                       *}
{*   Rozwizanie zadania: RAKIETY                                        *}
{*   Plik:                RAK.PAS                                        *}
{*   Autor:               Adam Borowski                                  *}
{*************************************************************************}

type
  TWsp=array[1..10000] of integer;
var
  n:word;
  x1,y1,x2,y2,m1,m2:^TWsp; {permutacja danych wejciowych}
  wynik:TWsp;

function lewo(x1,y1,x2,y2,x,y:integer):boolean; {czy (x,y) ley na lewo}
begin                                           {od wektora (x1,y1)->(x2,y2)}
  lewo:=longint(y1-y)*(x2-x1)<longint(y1-y2)*(x-x1)
end;


function Divide(var x,y,m:TWsp;x0,y0,mx,my:integer;min,max:word):word;
var                 {podzia zbioru punktw na lece po obu stronach prostej}
  i,j:word;
  tmp:integer;
begin
  i:=min;
  j:=max;
  repeat
    while (i<=max) and lewo(x0,y0,mx,my,x[i],y[i])
      do inc(i);
    while (j>=min) and lewo(x0,y0,x[j],y[j],mx,my)
      do dec(j);
    if i<=j
      then begin
             tmp:=x[i]; x[i]:=x[j]; x[j]:=tmp;
             tmp:=y[i]; y[i]:=y[j]; y[j]:=tmp;
             tmp:=m[i]; m[i]:=m[j]; m[j]:=tmp;
             inc(i); dec(j)
           end
  until i>j;
  Divide:=j
end;




function Median(var x,y,m:TWsp;x0,y0:integer;min,max:word):word;
var                 {szukanie mediany nachylenia wektora (x0,y0)->(x[i],y[i])}
  l,r,i,j,k:word;
  mx,my,tmp:integer;
begin
  l:=min;
  r:=max;
  k:=(min+max) div 2;
  while l<>r
    do begin
         j:=l+random(r-l);
         mx:=x[j];
         my:=y[j];
         i:=l;
         j:=r;
         repeat
           while (i<=max) and lewo(x0,y0,mx,my,x[i],y[i])
             do inc(i);
           while (j>=min) and lewo(x0,y0,x[j],y[j],mx,my)
             do dec(j);
           if i<=j
             then begin
                    tmp:=x[i]; x[i]:=x[j]; x[j]:=tmp;
                    tmp:=y[i]; y[i]:=y[j]; y[j]:=tmp;
                    tmp:=m[i]; m[i]:=m[j]; m[j]:=tmp;
                    inc(i); dec(j)
                  end
         until i>j;
         if i-1>j
           then inc(j);
         if j<k
           then l:=j+1
           else r:=i-1
       end;
  Median:=l
end;


function Partition(var x1,y1,x2,y2,m1,m2:TWsp;min,max:word):word;
var                        {metoda "dziel i rzd" wymaga funkcji "dziel"...}
  x0,y0,mx,my:integer;
  min1,max1,min2,max2:word;
  i,j:word;
begin
  x0:=x1[min];
  y0:=y1[min];
  min1:=min+1;
  max1:=max;
  min2:=min;
  max2:=max;

  repeat
    j:=Median(x2,y2,m2,x0,y0,min2,max2);
    mx:=x2[j];
    my:=y2[j];
    i:=Divide(x1,y1,m1,x0,y0,mx,my,min1,max1);
    if i<=j
      then begin
             max1:=i+1;
             max2:=j-1
           end
      else begin
             min1:=i;
             min2:=j+1
           end
  until i=j;

  x0:=x2[j]; x2[j]:=x2[min]; x2[min]:=x0;
  y0:=y2[j]; y2[j]:=y2[min]; y2[min]:=y0;
  i :=m2[j]; m2[j]:=m2[min]; m2[min]:=i ;
  Partition:=j
end;

procedure Solve(min,max:word); {rozwi rekurencyjnie metod dziel i rzd}
var
  mx,my:integer;
  i,best:word;
  k:boolean;
begin
  while max>min
    do begin
         k:=true;
         mx:=32767;
         my:=32767;             {szukamy punktu pierwszego z lewej}
         for i:=min to max
           do if x1^[i]<=mx
                then if (x1^[i]<mx) or (y1^[i]<my)
                       then begin
                              best:=i;
                              mx:=x1^[i];
                              my:=y1^[i]
                            end;
         for i:=min to max
           do if x2^[i]<=mx
                then if (x2^[i]<mx) or (y2^[i]<my)
                       then begin
                              k:=false;
                              best:=i;
                              mx:=x2^[i];
                              my:=y2^[i]
                            end;
         if k
           then begin
                  x1^[best]:=x1^[min]; x1^[min]:=mx;
                  y1^[best]:=y1^[min]; y1^[min]:=my;
                  i:=m1^[best]; m1^[best]:=m1^[min]; m1^[min]:=i;
                  best:=Partition(x1^,y1^,x2^,y2^,m1^,m2^,min,max)
                end
           else begin
                  x2^[best]:=x2^[min]; x2^[min]:=mx;
                  y2^[best]:=y2^[min]; y2^[min]:=my;
                  i:=m2^[best]; m2^[best]:=m2^[min]; m2^[min]:=i;
                  best:=Partition(x2^,y2^,x1^,y1^,m2^,m1^,min,max)
                end;
         wynik[m1^[min]]:=m2^[min];
         if best-min<max-best {rekurencja ogonowa -
                               wywoujemy dla mniejszej czci}
           then begin
                  Solve(min+1,best);
                  min:=best+1
                end
           else begin
                  Solve(best+1,max);
                  inc(min);
                  max:=best
                end
       end;
  if min=max
    then begin
           wynik[m1^[min]]:=m2^[min];
           exit
         end
end;

var
  i:word;
begin
  new(x1); new(y1);
  new(x2); new(y2);
  assign(input,'rak.in');
  reset(input);
  readln(n);
  for i:=1 to n
    do readln(x1^[i],y1^[i]);
  for i:=1 to n
    do readln(x2^[i],y2^[i]);
  close(input);
  new(m1); new(m2);
  for i:=1 to n
    do begin   {na pocztku permutacja identycznociowa}
         m1^[i]:=i;
         m2^[i]:=i
       end;
  Solve(1,n);
  assign(output,'rak.out');
  rewrite(output);
  for i:=1 to n
    do writeln(wynik[i]);
  close(output)
end.