 /*************************************************************************
 *                                                                       *
 *                    XVIII Olimpiada Informatyczna                      *
 *                                                                       *
 *   Zadanie:           Patyczki                                         *
 *   Autor:             Alan Kutniewski                                  *
 *   Zlozonosc czasowa: O(n * lg(n))                                     *
 *   Opis:              Rozwiazanie wzorcowe wariant 1                   *
 *                                                                       *
 *************************************************************************/

#include <iostream>
#include <algorithm>
#include <vector>
#define INF 1000000001

using namespace std;

struct patyczek{
	int dl; //dugo
	int kol; //kolor
}_p;
bool operator<(const patyczek &a, const patyczek &b){
	if(a.dl != b.dl)return a.dl > b.dl;
	return a.kol < b.kol;
}

struct delta{ 
	int d; //rnica midzy dugoci dwch kolejnych patyczkw
	int k1, k2; //kolory tych patyczkw
	int p; //index pierwszego patyczka (po posortowaniu), drugi to bdzie p+1
}_d;
bool operator<(const delta &a, const delta &b){
	return a.d < b.d;
}
int kolnach(delta a, delta b){ //ile kolorw delty maj wsplnych
	int ret = 0;
	if(a.k1 == b.k1 || a.k1 == b.k2)++ret;
	if(a.k2 == b.k1 || a.k2 == b.k2)++ret;
	return ret;
}

vector <patyczek> p; //vector trzymajcy patyczki
int n, k, m; //n - ilo patyczkw, k - ilo kolorw, m - ilo patyczkw w kolorze
delta d[3]; //musimy pamita 3 delty, eby mie najlepszych kandydatw dla kadego koloru
char ostkol; //ostatni kolor

int main(){
	//Wczytywanie danych
	ios_base::sync_with_stdio(0);
	cin >> k;
	for(int i = 0;i < k; ++i){
		cin >> m;
		n += m;
		_p.kol = i + 1;
		for(int j = 0; j < m; ++j){
			cin >> _p.dl;
			p.push_back(_p);
		}
	}
	sort(p.begin(), p.end()); //sortujemy patyczki po dugoci
	d[0].d = d[1].d = d[2].d = INF; //inicjalizujemy pocztkowe wartoci dla delt
	d[0].k1 = 1; d[0].k2 = 2;
	d[1].k1 = 1; d[1].k2 = 3;
	d[2].k1 = 2; d[2].k2 = 3;
	ostkol = p[0].kol;
	//Algorytm waciwy
	for(int i = 1; i < n; ++i){
		//Sprawdzenie, czy mona zbudowa trjkt
		_d.k1 = p[i].kol; //uzupeniamy kolor w aktualnej delcie
		_d.k2 = -1; //drugi kolor ustawiamy na razie tak, eby nie przeszkadza
		for(int j = 0; j < 3; ++j){
			if(kolnach(d[j], _d) == 0 && d[j].d < p[i].dl){ //rnica bya mniejsza ni d aktualnego i kolory pasuj
				int ind = d[j].p;
				cout << (int)p[i].kol << " " << p[i].dl << " ";
				cout << (int)p[ind].kol << " " << p[ind].dl << " ";
				++ind;
				cout << (int)p[ind].kol << " " << p[ind].dl << "\n";
				return 0;
			}
		}
		//Poprawianie delt
		if(p[i].kol == ostkol)continue;
		ostkol = p[i].kol; 
		int in = 0;   //ile nachodzi - eby delty byy dobrze wybrane musimy zamieni z tak, w ktrej najwicej jest wsplnych
		int bd = 0; //dalej musimy wybra tak, ktrej d jest jak najwiksze, bo je minimalizujemy
		int zd = -1; //a to index wybranej delty do zamiany lub -1, gdy nie opaca si zamienia
		_d.k2 = p[i - 1].kol; //uzupeniamy pozostae pola aktualnej delty
		_d.d = (p[i - 1].dl - p[i].dl);
		_d.p = i - 1;
		for(int j = 0; j < 3; ++j){ //szukamy delty z ktr moemy i opaca nam si zamieni aktualn delt
			if(in < kolnach(d[j], _d)){ //jeli wicej kolorw nachodzi ni poprzednio, to anulujemy wybr
				zd = -1;
				bd = 0;
				in = kolnach(d[j], _d);
			}
			if(in <= kolnach(d[j], _d) && bd <= d[j].d){ //jeli opaca si i moemy zamieni z dan delt, to j wybieramy
				in = kolnach(d[j], _d);
				bd = d[j].d;
				zd = j;
			}
		}
		if(zd != -1 && bd > _d.d)d[zd] = _d; //jeli ostatecznie opaca si zamieni, to zamieniamy
	}
	cout << "NIE\n"; //jeli nie zakoczylimy wczeniej programu, to znaczy, e nie mona zbudowa trjktu
	return 0;
} 
